/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.liblinear;

import de.bwaldvogel.liblinear.FeatureNode;
import de.bwaldvogel.liblinear.Model;
import de.bwaldvogel.liblinear.Train;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.cleartk.ml.jar.ClassifierBuilder_ImplBase;
import org.cleartk.ml.jar.JarStreams;
import org.cleartk.ml.liblinear.GenericLibLinearClassifier;

public abstract class GenericLibLinearClassifierBuilder<CLASSIFIER_TYPE extends GenericLibLinearClassifier<OUTCOME_TYPE>, OUTCOME_TYPE>
extends ClassifierBuilder_ImplBase<CLASSIFIER_TYPE, FeatureNode[], OUTCOME_TYPE, Integer> {
    protected Model model;

    public File getTrainingDataFile(File dir) {
        return new File(dir, "training-data.liblinear");
    }

    private String getModelName() {
        return "model.liblinear";
    }

    private File getModelFile(File dir) {
        return new File(dir, this.getModelName());
    }

    public void trainClassifier(File dir, String ... args) throws Exception {
        args = Arrays.copyOf(args, args.length + 2);
        args[args.length - 2] = this.getTrainingDataFile(dir).getPath();
        args[args.length - 1] = this.getModelFile(dir).getPath();
        Train.main((String[])args);
    }

    protected void packageClassifier(File dir, JarOutputStream modelStream) throws IOException {
        super.packageClassifier(dir, modelStream);
        JarStreams.putNextJarEntry((JarOutputStream)modelStream, (String)this.getModelName(), (File)this.getModelFile(dir));
    }

    protected void unpackageClassifier(JarInputStream modelStream) throws IOException {
        super.unpackageClassifier(modelStream);
        JarStreams.getNextJarEntry((JarInputStream)modelStream, (String)this.getModelName());
        this.model = Model.load((Reader)new InputStreamReader(modelStream));
    }
}

