/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.data.parse;

import edu.mit.jwi.data.parse.ILineParser;
import edu.mit.jwi.item.IIndexWord;
import edu.mit.jwi.item.ISynsetID;
import edu.mit.jwi.item.IWordID;
import edu.mit.jwi.item.IndexWord;
import edu.mit.jwi.item.POS;
import edu.mit.jwi.item.SynsetID;
import edu.mit.jwi.item.WordID;
import java.util.StringTokenizer;

public class IndexLineParser
implements ILineParser<IIndexWord> {
    private static IndexLineParser instance;

    public static IndexLineParser getInstance() {
        if (instance == null) {
            instance = new IndexLineParser();
        }
        return instance;
    }

    protected IndexLineParser() {
    }

    @Override
    public IIndexWord parseLine(String line) {
        if (line == null) {
            throw new NullPointerException();
        }
        try {
            StringTokenizer tokenizer = new StringTokenizer(line, " ");
            String lemma = tokenizer.nextToken();
            String posSym = tokenizer.nextToken();
            POS pos = POS.getPartOfSpeech(posSym.charAt(0));
            tokenizer.nextToken();
            int p_cnt = Integer.parseInt(tokenizer.nextToken());
            for (int i = 0; i < p_cnt; ++i) {
                tokenizer.nextToken();
            }
            int senseCount = Integer.parseInt(tokenizer.nextToken());
            int tagSenseCnt = Integer.parseInt(tokenizer.nextToken());
            IWordID[] words = new IWordID[senseCount];
            for (int i = 0; i < senseCount; ++i) {
                int offset = Integer.parseInt(tokenizer.nextToken());
                words[i] = new WordID((ISynsetID)new SynsetID(offset, pos), lemma);
            }
            return new IndexWord(lemma, pos, tagSenseCnt, words);
        }
        catch (Exception e) {
            throw new ILineParser.MisformattedLineException(line, e);
        }
    }
}

