/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.sql.DataSource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.ytex.kernel.FileUtil;
import org.apache.ctakes.ytex.kernel.FoldGenerator;
import org.apache.ctakes.ytex.kernel.InstanceData;
import org.apache.ctakes.ytex.kernel.KernelUtil;
import org.apache.ctakes.ytex.kernel.dao.ClassifierEvaluationDao;
import org.apache.ctakes.ytex.kernel.dao.KernelEvaluationDao;
import org.apache.ctakes.ytex.kernel.model.CrossValidationFold;
import org.apache.ctakes.ytex.kernel.model.KernelEvaluation;
import org.apache.ctakes.ytex.kernel.model.KernelEvaluationInstance;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class KernelUtilImpl
implements KernelUtil {
    private static final Log log = LogFactory.getLog(KernelUtilImpl.class);
    private ClassifierEvaluationDao classifierEvaluationDao;
    private JdbcTemplate jdbcTemplate = null;
    private KernelEvaluationDao kernelEvaluationDao = null;
    private PlatformTransactionManager transactionManager;
    private FoldGenerator foldGenerator = null;

    public FoldGenerator getFoldGenerator() {
        return this.foldGenerator;
    }

    public void setFoldGenerator(FoldGenerator foldGenerator) {
        this.foldGenerator = foldGenerator;
    }

    private Map<Long, Integer> createInstanceIdToIndexMap(SortedSet<Long> instanceIDs) {
        HashMap<Long, Integer> instanceIdToIndexMap = new HashMap<Long, Integer>(instanceIDs.size());
        int i = 0;
        for (Long instanceId : instanceIDs) {
            instanceIdToIndexMap.put(instanceId, i);
            ++i;
        }
        return instanceIdToIndexMap;
    }

    @Override
    public void fillGramMatrix(final KernelEvaluation kernelEvaluation, SortedSet<Long> trainInstanceLabelMap, final double[][] trainGramMatrix) {
        final Map<Long, Integer> trainInstanceToIndexMap = this.createInstanceIdToIndexMap(trainInstanceLabelMap);
        for (Map.Entry<Long, Integer> instanceIdIndex : trainInstanceToIndexMap.entrySet()) {
            final int indexThis = instanceIdIndex.getValue();
            final long instanceId = instanceIdIndex.getKey();
            TransactionTemplate t = new TransactionTemplate(this.transactionManager);
            t.setPropagationBehavior(3);
            t.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction(TransactionStatus arg0) {
                    List<KernelEvaluationInstance> kevals = KernelUtilImpl.this.getKernelEvaluationDao().getAllKernelEvaluationsForInstance(kernelEvaluation, instanceId);
                    for (KernelEvaluationInstance keval : kevals) {
                        Integer indexOtherTrain = null;
                        long instanceIdOther = instanceId != keval.getInstanceId1() ? keval.getInstanceId1() : keval.getInstanceId2();
                        indexOtherTrain = (Integer)trainInstanceToIndexMap.get(instanceIdOther);
                        if (indexOtherTrain == null) continue;
                        trainGramMatrix[indexThis][indexOtherTrain.intValue()] = keval.getSimilarity();
                        trainGramMatrix[indexOtherTrain.intValue()][indexThis] = keval.getSimilarity();
                    }
                    return null;
                }
            });
        }
        for (int i = 0; i < trainGramMatrix.length; ++i) {
            if (trainGramMatrix[i][i] != 0.0) continue;
            trainGramMatrix[i][i] = 1.0;
        }
    }

    public ClassifierEvaluationDao getClassifierEvaluationDao() {
        return this.classifierEvaluationDao;
    }

    public DataSource getDataSource() {
        return this.jdbcTemplate.getDataSource();
    }

    public KernelEvaluationDao getKernelEvaluationDao() {
        return this.kernelEvaluationDao;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public double[][] loadGramMatrix(SortedSet<Long> instanceIds, String name, String splitName, String experiment, String label, int run, int fold, double param1, String param2) {
        KernelEvaluation kernelEval;
        CrossValidationFold f;
        int foldId = 0;
        double[][] gramMatrix = null;
        if (run != 0 && fold != 0 && (f = this.classifierEvaluationDao.getCrossValidationFold(name, splitName, label, run, fold)) != null) {
            foldId = f.getCrossValidationFoldId();
        }
        if ((kernelEval = this.kernelEvaluationDao.getKernelEval(name, experiment, label, foldId, param1, param2)) == null) {
            log.warn((Object)("could not find kernelEvaluation.  name=" + name + ", experiment=" + experiment + ", label=" + label + ", fold=" + fold + ", run=" + run));
        } else {
            gramMatrix = new double[instanceIds.size()][instanceIds.size()];
            this.fillGramMatrix(kernelEval, instanceIds, gramMatrix);
        }
        return gramMatrix;
    }

    @Override
    public InstanceData loadInstances(String strQuery) {
        final InstanceData instanceLabel = new InstanceData();
        Statement s = null;
        Connection conn = null;
        ResultSet rs = null;
        try {
            RowCallbackHandler ch = new RowCallbackHandler(){

                public void processRow(ResultSet rs) throws SQLException {
                    TreeMap<Long, String> instanceToClassMap;
                    TreeMap<Boolean, TreeMap<Long, String>> ttToClassMap;
                    TreeMap foldToInstanceMap;
                    TreeMap runToInstanceMap;
                    String label = "";
                    int run = 0;
                    int fold = 0;
                    boolean train = true;
                    long instanceId = rs.getLong(1);
                    String className = rs.getString(2);
                    if (rs.getMetaData().getColumnCount() >= 3) {
                        train = rs.getBoolean(3);
                    }
                    if (rs.getMetaData().getColumnCount() >= 4 && (label = rs.getString(4)) == null) {
                        label = "";
                    }
                    if (rs.getMetaData().getColumnCount() >= 5) {
                        fold = rs.getInt(5);
                    }
                    if (rs.getMetaData().getColumnCount() >= 6) {
                        run = rs.getInt(6);
                    }
                    if ((runToInstanceMap = (TreeMap)instanceLabel.getLabelToInstanceMap().get(label)) == null) {
                        runToInstanceMap = new TreeMap();
                        instanceLabel.getLabelToInstanceMap().put(label, runToInstanceMap);
                    }
                    if ((foldToInstanceMap = (TreeMap)runToInstanceMap.get(run)) == null) {
                        foldToInstanceMap = new TreeMap();
                        runToInstanceMap.put(run, foldToInstanceMap);
                    }
                    if ((ttToClassMap = (TreeMap<Boolean, TreeMap<Long, String>>)foldToInstanceMap.get(fold)) == null) {
                        ttToClassMap = new TreeMap<Boolean, TreeMap<Long, String>>();
                        foldToInstanceMap.put(fold, ttToClassMap);
                    }
                    if ((instanceToClassMap = (TreeMap<Long, String>)ttToClassMap.get(train)) == null) {
                        instanceToClassMap = new TreeMap<Long, String>();
                        ttToClassMap.put(train, instanceToClassMap);
                    }
                    instanceToClassMap.put(instanceId, className);
                    TreeSet<String> labelClasses = (TreeSet<String>)instanceLabel.getLabelToClassMap().get(label);
                    if (labelClasses == null) {
                        labelClasses = new TreeSet<String>();
                        instanceLabel.getLabelToClassMap().put(label, labelClasses);
                    }
                    if (!labelClasses.contains(className)) {
                        labelClasses.add(className);
                    }
                }
            };
            conn = this.jdbcTemplate.getDataSource().getConnection();
            s = conn.prepareStatement(strQuery, 1003, 1007);
            if ("MySQL".equals(conn.getMetaData().getDatabaseProductName())) {
                s.setFetchSize(Integer.MIN_VALUE);
            } else if (s.getClass().getName().equals("com.microsoft.sqlserver.jdbc.SQLServerStatement")) {
                try {
                    BeanUtils.setProperty((Object)s, (String)"responseBuffering", (Object)"adaptive");
                }
                catch (IllegalAccessException e) {
                    log.warn((Object)"error setting responseBuffering", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    log.warn((Object)"error setting responseBuffering", (Throwable)e);
                }
            }
            rs = s.executeQuery();
            while (rs.next()) {
                ch.processRow(rs);
            }
        }
        catch (SQLException j) {
            log.error((Object)"loadInstances failed", (Throwable)j);
            throw new RuntimeException(j);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return instanceLabel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadProperties(String propertyFile, Properties props) throws FileNotFoundException, IOException, InvalidPropertiesFormatException {
        try (FileInputStream in = null;){
            in = new FileInputStream(propertyFile);
            if (propertyFile.endsWith(".xml")) {
                props.loadFromXML(in);
            } else {
                props.load(in);
            }
        }
    }

    public void setClassifierEvaluationDao(ClassifierEvaluationDao classifierEvaluationDao) {
        this.classifierEvaluationDao = classifierEvaluationDao;
    }

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public void setKernelEvaluationDao(KernelEvaluationDao kernelEvaluationDao) {
        this.kernelEvaluationDao = kernelEvaluationDao;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public void generateFolds(InstanceData instanceLabel, Properties props) {
        int folds = Integer.parseInt(props.getProperty("folds"));
        int runs = Integer.parseInt(props.getProperty("runs", "1"));
        int minPerClass = Integer.parseInt(props.getProperty("minPerClass", "0"));
        Integer randomNumberSeed = props.containsKey("rand") ? Integer.valueOf(Integer.parseInt(props.getProperty("rand"))) : null;
        instanceLabel.setLabelToInstanceMap(this.foldGenerator.generateRuns(instanceLabel.getLabelToInstanceMap(), folds, minPerClass, randomNumberSeed, runs));
    }

    @Override
    public void fillLabelToClassToIndexMap(Map<String, SortedSet<String>> labelToClasMap, Map<String, BiMap<String, Integer>> labelToClassIndexMap) {
        for (Map.Entry<String, SortedSet<String>> labelToClass : labelToClasMap.entrySet()) {
            HashBiMap classToIndexMap = HashBiMap.create();
            labelToClassIndexMap.put(labelToClass.getKey(), (BiMap<String, Integer>)classToIndexMap);
            int nIndex = 1;
            for (String className : labelToClass.getValue()) {
                Integer classNumber = null;
                try {
                    classNumber = Integer.parseInt(className);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (classNumber == null) {
                    classToIndexMap.put((Object)className, (Object)nIndex++);
                    continue;
                }
                classToIndexMap.put((Object)className, (Object)classNumber);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportClassIds(String outdir, Map<String, Integer> classIdMap, String label) throws IOException {
        String filename = FileUtil.getScopedFileName(outdir, label, null, null, "class.properties");
        Properties props = new Properties();
        for (Map.Entry<String, Integer> entry : classIdMap.entrySet()) {
            props.put(entry.getValue().toString(), entry.getKey());
        }
        try (BufferedWriter w = null;){
            w = new BufferedWriter(new FileWriter(filename));
            props.store(w, "class id to class name map");
        }
    }
}

