/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.viterbi;

import java.io.File;
import java.io.IOException;
import org.apache.uima.UimaContext;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.fit.component.initialize.ConfigurationParameterInitializer;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.initializable.Initializable;
import org.apache.uima.fit.factory.initializable.InitializableFactory;
import org.apache.uima.resource.ConfigurationManager;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.DataWriter;
import org.cleartk.ml.DataWriterFactory;
import org.cleartk.ml.SequenceDataWriter;
import org.cleartk.ml.SequenceDataWriterFactory;
import org.cleartk.ml.jar.DirectoryDataWriterFactory;
import org.cleartk.ml.viterbi.OutcomeFeatureExtractor;
import org.cleartk.ml.viterbi.ViterbiClassifierBuilder;
import org.cleartk.ml.viterbi.ViterbiDataWriter;

public class ViterbiDataWriterFactory<OUTCOME_TYPE>
extends DirectoryDataWriterFactory
implements SequenceDataWriterFactory<OUTCOME_TYPE>,
Initializable {
    public static final String PARAM_OUTCOME_FEATURE_EXTRACTOR_NAMES = "outcomeFeatureExtractorNames";
    @ConfigurationParameter(name="outcomeFeatureExtractorNames", mandatory=false, description="An optional, multi-valued, string parameter that specifies which OutcomeFeatureExtractors should be used. Each value of this parameter should be the name of a class that implements OutcomeFeatureExtractor. One valid value that you might use is org.cleartk.ml.feature.extractor.outcome.DefaultOutcomeFeatureExtractor")
    protected String[] outcomeFeatureExtractorNames;
    public static final String PARAM_DELEGATED_DATA_WRITER_FACTORY_CLASS = "delegatedDataWriterFactoryClass";
    @ConfigurationParameter(name="delegatedDataWriterFactoryClass", mandatory=true, defaultValue={"org.cleartk.ml.jar.DefaultDataWriterFactory"}, description="A single, required, string parameter that provides the full name of the DataWriterFactory class that will be wrapped.")
    protected String delegatedDataWriterFactoryClass;
    private ViterbiDataWriter<OUTCOME_TYPE> dataWriter;

    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        OutcomeFeatureExtractor[] outcomeFeatureExtractors;
        super.initialize(context);
        ConfigurationParameterInitializer.initialize((Object)this, (UimaContext)context);
        if (this.outcomeFeatureExtractorNames == null) {
            outcomeFeatureExtractors = new OutcomeFeatureExtractor[]{};
        } else {
            outcomeFeatureExtractors = new OutcomeFeatureExtractor[this.outcomeFeatureExtractorNames.length];
            for (int i = 0; i < this.outcomeFeatureExtractorNames.length; ++i) {
                outcomeFeatureExtractors[i] = (OutcomeFeatureExtractor)InitializableFactory.create((UimaContext)context, (String)this.outcomeFeatureExtractorNames[i], OutcomeFeatureExtractor.class);
            }
        }
        this.dataWriter = new ViterbiDataWriter(this.outputDirectory, outcomeFeatureExtractors);
        UimaContextAdmin contextAdmin = (UimaContextAdmin)context;
        ConfigurationManager manager = contextAdmin.getConfigurationManager();
        ViterbiClassifierBuilder builder = (ViterbiClassifierBuilder)this.dataWriter.getClassifierBuilder();
        File delegatedDir = builder.getDelegatedModelDirectory(this.outputDirectory);
        manager.setConfigParameterValue(contextAdmin.getQualifiedContextName() + "outputDirectory", (Object)delegatedDir.getPath());
        try {
            DataWriterFactory<OUTCOME_TYPE> delegatedDataWriterFactory = this.createDelegatedDataWriterFactory(this.delegatedDataWriterFactoryClass, context);
            DataWriter<OUTCOME_TYPE> delegatedDataWriter = delegatedDataWriterFactory.createDataWriter();
            this.dataWriter.setDelegatedDataWriter(delegatedDataWriter);
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        finally {
            manager.setConfigParameterValue(contextAdmin.getQualifiedContextName() + "outputDirectory", (Object)this.outputDirectory.getPath());
        }
    }

    @Override
    public SequenceDataWriter<OUTCOME_TYPE> createDataWriter() {
        return this.dataWriter;
    }

    private DataWriterFactory<OUTCOME_TYPE> createDelegatedDataWriterFactory(String delegatedDataWriterFactoryClassName, UimaContext context) throws ResourceInitializationException {
        return (DataWriterFactory)InitializableFactory.create((UimaContext)context, (String)delegatedDataWriterFactoryClassName, DataWriterFactory.class);
    }
}

