/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.ae.features.cluster;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.core.util.ListIterable;
import org.apache.ctakes.coreference.ae.features.TokenFeatureExtractor;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.relation.CollectionTextRelation;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.Markable;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;

public class MentionClusterAgreementFeaturesExtractor
implements RelationFeaturesExtractor<CollectionTextRelation, IdentifiedAnnotation>,
FeatureExtractor1<Markable> {
    public List<Feature> extract(JCas jCas, CollectionTextRelation cluster, IdentifiedAnnotation mention) throws AnalysisEngineProcessException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        String s = mention.getCoveredText().toLowerCase();
        boolean isDem = TokenFeatureExtractor.isDemonstrative(s);
        boolean isDef = TokenFeatureExtractor.isDefinite(s);
        String gender = TokenFeatureExtractor.getGender(s);
        boolean singular = TokenFeatureExtractor.numberSingular(jCas, (Annotation)mention, s);
        boolean matchDem = false;
        boolean matchDef = false;
        boolean matchGender = false;
        boolean matchNumber = false;
        for (IdentifiedAnnotation member : new ListIterable(cluster.getMembers())) {
            if (member == null) {
                System.err.println("Found an empty cluster member in agreement features extractor.");
                continue;
            }
            if (mention.getBegin() < member.getEnd()) continue;
            String m = member.getCoveredText().toLowerCase();
            if (!matchDem && TokenFeatureExtractor.isDemonstrative(m) == isDem) {
                matchDem = true;
            }
            if (!matchDef && TokenFeatureExtractor.isDefinite(m) == isDef) {
                matchDef = true;
            }
            if (!matchGender && TokenFeatureExtractor.getGender(m).equals(gender)) {
                matchGender = true;
            }
            if (matchNumber || TokenFeatureExtractor.numberSingular(jCas, (Annotation)member, m) != singular) continue;
            matchNumber = true;
        }
        features.add(new Feature("MC_AGREE_DEM", (Object)matchDem));
        features.add(new Feature("MC_AGREE_DEF", (Object)matchDef));
        features.add(new Feature("MC_AGREE_GEN", (Object)matchGender));
        features.add(new Feature("MC_AGREE_NUM", (Object)matchNumber));
        return features;
    }

    public List<Feature> extract(JCas jCas, Markable mention) throws CleartkExtractorException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        String s = mention.getCoveredText().toLowerCase();
        boolean isDem = TokenFeatureExtractor.isDemonstrative(s);
        boolean isDef = TokenFeatureExtractor.isDefinite(s);
        features.add(new Feature("MC_MENTION_DEM", (Object)isDem));
        features.add(new Feature("MC_MENTION_DEF", (Object)isDef));
        String gender = TokenFeatureExtractor.getGender(s);
        features.add(new Feature("MC_MENTION_GENDER", (Object)gender));
        boolean singular = TokenFeatureExtractor.numberSingular(jCas, (Annotation)mention, s);
        features.add(new Feature("MC_MENTION_NUMBER", (Object)singular));
        return features;
    }
}

