/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.ae.features.cluster;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ctakes.core.util.ListIterable;
import org.apache.ctakes.coreference.ae.MarkableHeadTreeCreator;
import org.apache.ctakes.coreference.ae.features.StringMatchingFeatureExtractor;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.relation.CollectionTextRelation;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.utils.struct.CounterMap;
import org.apache.ctakes.utils.struct.MapFactory;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;

public class MentionClusterStringFeaturesExtractor
implements RelationFeaturesExtractor<CollectionTextRelation, IdentifiedAnnotation> {
    public List<Feature> extract(JCas jCas, CollectionTextRelation cluster, IdentifiedAnnotation mention) throws AnalysisEngineProcessException {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        CounterMap featCounts = new CounterMap();
        if (StringMatchingFeatureExtractor.isPronoun(mention)) {
            return feats;
        }
        String m = mention.getCoveredText();
        Set<String> mentionWords = StringMatchingFeatureExtractor.contentWords((Annotation)mention);
        HashSet<String> nonHeadMentionWords = new HashSet<String>(mentionWords);
        ConllDependencyNode mentionHead = (ConllDependencyNode)MapFactory.get((String)MarkableHeadTreeCreator.getKey(jCas), (TOP)mention);
        String mentionHeadString = null;
        if (mentionHead != null) {
            mentionHeadString = mentionHead.getCoveredText().toLowerCase();
            nonHeadMentionWords.remove(mentionHeadString);
            int maxNonoverlap = 0;
            for (IdentifiedAnnotation member : new ListIterable(cluster.getMembers())) {
                int nonHeadOverlap;
                if (member == null) {
                    System.err.println("Something that shouldn't happen has happened");
                    continue;
                }
                if (mention.getBegin() < member.getEnd() || StringMatchingFeatureExtractor.isPronoun(member)) continue;
                String s = member.getCoveredText();
                Set<String> memberWords = StringMatchingFeatureExtractor.contentWords((Annotation)member);
                HashSet<String> nonHeadMemberWords = new HashSet<String>(memberWords);
                ConllDependencyNode memberHead = (ConllDependencyNode)MapFactory.get((String)MarkableHeadTreeCreator.getKey(jCas), (TOP)member);
                String memberHeadString = null;
                if (memberHead == null) continue;
                memberHeadString = memberHead.getCoveredText().toLowerCase();
                nonHeadMemberWords.remove(memberHeadString);
                if (!mentionHeadString.equals(memberHeadString)) continue;
                if (m.equalsIgnoreCase(s)) {
                    featCounts.add((Object)"MC_STRING_EXACT");
                }
                if (StringMatchingFeatureExtractor.startMatch(m, s)) {
                    featCounts.add((Object)"MC_STRING_START");
                }
                if (StringMatchingFeatureExtractor.endMatch(m, s)) {
                    featCounts.add((Object)"MC_STRING_END");
                }
                if (StringMatchingFeatureExtractor.soonMatch(m, s)) {
                    featCounts.add((Object)"MC_STRING_SOON");
                }
                if (StringMatchingFeatureExtractor.wordOverlap(mentionWords, memberWords)) {
                    featCounts.add((Object)"MC_OVERLAP");
                }
                if (StringMatchingFeatureExtractor.wordSubstring(mentionWords, memberWords)) {
                    featCounts.add((Object)"MC_SUB");
                }
                if ((nonHeadOverlap = MentionClusterStringFeaturesExtractor.wordNonOverlapCount(nonHeadMemberWords, nonHeadMentionWords)) <= maxNonoverlap) continue;
                maxNonoverlap = nonHeadOverlap;
            }
            feats.add(new Feature("MC_MAX_NONOVERLAP", (Object)maxNonoverlap));
        }
        for (String featKey : featCounts.keySet()) {
            feats.add(new Feature(featKey, (Object)true));
        }
        return feats;
    }

    public static int wordNonOverlapCount(Set<String> w1, Set<String> w2) {
        int count = 0;
        for (String w : w1) {
            if (w2.contains(w)) continue;
            ++count;
        }
        for (String w : w2) {
            if (w1.contains(w)) continue;
            ++count;
        }
        return count;
    }
}

