/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.contexttokenizer.ae;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.ctakes.core.fsm.adapters.ContractionTokenAdapter;
import org.apache.ctakes.core.fsm.adapters.DecimalTokenAdapter;
import org.apache.ctakes.core.fsm.adapters.IntegerTokenAdapter;
import org.apache.ctakes.core.fsm.adapters.NewlineTokenAdapter;
import org.apache.ctakes.core.fsm.adapters.PunctuationTokenAdapter;
import org.apache.ctakes.core.fsm.adapters.SymbolTokenAdapter;
import org.apache.ctakes.core.fsm.adapters.WordTokenAdapter;
import org.apache.ctakes.core.fsm.machine.DateFSM;
import org.apache.ctakes.core.fsm.machine.FractionFSM;
import org.apache.ctakes.core.fsm.machine.MeasurementFSM;
import org.apache.ctakes.core.fsm.machine.PersonTitleFSM;
import org.apache.ctakes.core.fsm.machine.RangeFSM;
import org.apache.ctakes.core.fsm.machine.RomanNumeralFSM;
import org.apache.ctakes.core.fsm.machine.TimeFSM;
import org.apache.ctakes.core.fsm.output.DateToken;
import org.apache.ctakes.core.fsm.output.FractionToken;
import org.apache.ctakes.core.fsm.output.MeasurementToken;
import org.apache.ctakes.core.fsm.output.PersonTitleToken;
import org.apache.ctakes.core.fsm.output.RangeToken;
import org.apache.ctakes.core.fsm.output.RomanNumeralToken;
import org.apache.ctakes.core.fsm.output.TimeToken;
import org.apache.ctakes.core.fsm.token.EolToken;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.ContractionToken;
import org.apache.ctakes.typesystem.type.syntax.NewlineToken;
import org.apache.ctakes.typesystem.type.syntax.NumToken;
import org.apache.ctakes.typesystem.type.syntax.PunctuationToken;
import org.apache.ctakes.typesystem.type.syntax.SymbolToken;
import org.apache.ctakes.typesystem.type.syntax.WordToken;
import org.apache.ctakes.typesystem.type.textsem.DateAnnotation;
import org.apache.ctakes.typesystem.type.textsem.FractionAnnotation;
import org.apache.ctakes.typesystem.type.textsem.MeasurementAnnotation;
import org.apache.ctakes.typesystem.type.textsem.PersonTitleAnnotation;
import org.apache.ctakes.typesystem.type.textsem.RangeAnnotation;
import org.apache.ctakes.typesystem.type.textsem.RomanNumeralAnnotation;
import org.apache.ctakes.typesystem.type.textsem.TimeAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="Context Dependent Annotator", description="Finds tokens based upon context.  Time, Date, Roman numeral, Fraction, Range, Measurement, Person title.", dependencies={PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.BASE_TOKEN})
public class ContextDependentTokenizerAnnotator
extends JCasAnnotator_ImplBase {
    private Logger iv_logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    private DateFSM iv_dateFSM;
    private TimeFSM iv_timeFSM;
    private FractionFSM iv_fractionFSM;
    private RomanNumeralFSM iv_romanNumeralFSM;
    private RangeFSM iv_rangeFSM;
    private MeasurementFSM iv_measurementFSM;
    private PersonTitleFSM iv_personTitleFSM;

    public void initialize(UimaContext annotCtx) throws ResourceInitializationException {
        super.initialize(annotCtx);
        this.iv_dateFSM = new DateFSM();
        this.iv_timeFSM = new TimeFSM();
        this.iv_fractionFSM = new FractionFSM();
        this.iv_romanNumeralFSM = new RomanNumeralFSM();
        this.iv_rangeFSM = new RangeFSM();
        this.iv_measurementFSM = new MeasurementFSM();
        this.iv_personTitleFSM = new PersonTitleFSM();
        this.iv_logger.info((Object)"Finite state machines loaded.");
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        try {
            this.iv_logger.info((Object)"process(JCas)");
            Collection sents = JCasUtil.select((JCas)jcas, Sentence.class);
            for (Sentence sentAnnot : sents) {
                List tokens = JCasUtil.selectCovered(BaseToken.class, (AnnotationFS)sentAnnot);
                ArrayList<org.apache.ctakes.core.fsm.token.BaseToken> baseTokenList = new ArrayList<org.apache.ctakes.core.fsm.token.BaseToken>();
                for (BaseToken bta : tokens) {
                    org.apache.ctakes.core.fsm.token.BaseToken bt = ContextDependentTokenizerAnnotator.adaptToBaseToken(bta);
                    if (bt == null || bt instanceof EolToken) continue;
                    baseTokenList.add(bt);
                }
                this.executeFSMs(jcas, baseTokenList);
            }
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    private void executeFSMs(JCas jcas, List<? extends org.apache.ctakes.core.fsm.token.BaseToken> baseTokenList) throws AnalysisEngineProcessException {
        try {
            Set dateTokenSet = this.iv_dateFSM.execute(baseTokenList);
            for (DateToken dt : dateTokenSet) {
                DateAnnotation dta = new DateAnnotation(jcas, dt.getStartOffset(), dt.getEndOffset());
                dta.addToIndexes();
            }
            Set timeTokenSet = this.iv_timeFSM.execute(baseTokenList);
            for (TimeToken tt : timeTokenSet) {
                TimeAnnotation ta = new TimeAnnotation(jcas, tt.getStartOffset(), tt.getEndOffset());
                ta.addToIndexes();
            }
            Set romanNumeralTokenSet = this.iv_romanNumeralFSM.execute(baseTokenList);
            for (RomanNumeralToken rnt : romanNumeralTokenSet) {
                RomanNumeralAnnotation rna = new RomanNumeralAnnotation(jcas, rnt.getStartOffset(), rnt.getEndOffset());
                rna.addToIndexes();
            }
            Set fractionTokenSet = this.iv_fractionFSM.execute(baseTokenList);
            for (FractionToken ft : fractionTokenSet) {
                FractionAnnotation fa = new FractionAnnotation(jcas, ft.getStartOffset(), ft.getEndOffset());
                fa.addToIndexes();
            }
            Set rangeTokenSet = this.iv_rangeFSM.execute(baseTokenList, romanNumeralTokenSet);
            for (RangeToken rt : rangeTokenSet) {
                RangeAnnotation ra = new RangeAnnotation(jcas, rt.getStartOffset(), rt.getEndOffset());
                ra.addToIndexes();
            }
            Set measurementTokenSet = this.iv_measurementFSM.execute(baseTokenList, rangeTokenSet);
            for (MeasurementToken mt : measurementTokenSet) {
                MeasurementAnnotation ma = new MeasurementAnnotation(jcas, mt.getStartOffset(), mt.getEndOffset());
                ma.addToIndexes();
            }
            Set personTitleTokenSet = this.iv_personTitleFSM.execute(baseTokenList);
            for (PersonTitleToken ptt : personTitleTokenSet) {
                PersonTitleAnnotation pta = new PersonTitleAnnotation(jcas, ptt.getStartOffset(), ptt.getEndOffset());
                pta.addToIndexes();
            }
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    private static org.apache.ctakes.core.fsm.token.BaseToken adaptToBaseToken(BaseToken obj) throws Exception {
        if (obj instanceof WordToken) {
            WordToken wta = (WordToken)obj;
            return new WordTokenAdapter(wta);
        }
        if (obj instanceof NumToken) {
            NumToken nta = (NumToken)obj;
            if (nta.getNumType() == 1) {
                return new IntegerTokenAdapter(nta);
            }
            return new DecimalTokenAdapter(nta);
        }
        if (obj instanceof PunctuationToken) {
            PunctuationToken pta = (PunctuationToken)obj;
            return new PunctuationTokenAdapter(pta);
        }
        if (obj instanceof NewlineToken) {
            NewlineToken nta = (NewlineToken)obj;
            return new NewlineTokenAdapter(nta);
        }
        if (obj instanceof ContractionToken) {
            ContractionToken cta = (ContractionToken)obj;
            return new ContractionTokenAdapter(cta);
        }
        if (obj instanceof SymbolToken) {
            SymbolToken sta = (SymbolToken)obj;
            return new SymbolTokenAdapter(sta);
        }
        throw new Exception("No Context Dependent Tokenizer adapter for class: " + obj.getClass());
    }

    public static AnalysisEngineDescription createAnnotatorDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(ContextDependentTokenizerAnnotator.class, (Object[])new Object[0]);
    }
}

