/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cr;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.typesystem.type.structured.DocumentID;
import org.apache.log4j.Logger;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;

@PipeBitInfo(name="Lines in File Reader", description="Reads a document texts from a single text file, treating each line as a document.", role=PipeBitInfo.Role.READER, products={PipeBitInfo.TypeProduct.DOCUMENT_ID})
public class LinesFromFileCollectionReader
extends CollectionReader_ImplBase {
    public static final String PARAM_INPUT_FILE_NAME = "InputFileName";
    public static final String PARAM_COMMENT_STRING = "CommentString";
    public static final String PARAM_IGNORE_BLANK_LINES = "IgnoreBlankLines";
    public static final String PARAM_LANGUAGE = "Language";
    public static final String PARAM_ID_DELIMETER = "IdDelimeter";
    List<String> iv_linesFromFile;
    int iv_currentIndex = 0;
    String iv_language;
    String iv_delimeter;
    private Logger iv_logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());

    public void initialize() throws ResourceInitializationException {
        BufferedReader fileReader = null;
        try {
            String line;
            String fileLocation = (String)this.getConfigParameterValue(PARAM_INPUT_FILE_NAME);
            String commentSeq = (String)this.getConfigParameterValue(PARAM_COMMENT_STRING);
            this.iv_language = (String)this.getConfigParameterValue(PARAM_LANGUAGE);
            Boolean paramValue = (Boolean)this.getConfigParameterValue(PARAM_IGNORE_BLANK_LINES);
            boolean ignoreBlankLines = true;
            if (paramValue != null) {
                ignoreBlankLines = paramValue;
            }
            this.iv_delimeter = (String)this.getConfigParameterValue(PARAM_ID_DELIMETER);
            this.iv_linesFromFile = new ArrayList<String>();
            fileReader = new BufferedReader(new FileReader(fileLocation));
            while ((line = fileReader.readLine()) != null) {
                if (commentSeq != null && line.startsWith(commentSeq) || ignoreBlankLines && line.trim().length() == 0) continue;
                this.iv_linesFromFile.add(line);
            }
        }
        catch (IOException fnfe) {
            throw new ResourceInitializationException((Throwable)fnfe);
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void getNext(CAS cas) throws IOException, CollectionException {
        try {
            String text;
            String id;
            JCas jcas = cas.getJCas();
            String line = this.iv_linesFromFile.get(this.iv_currentIndex);
            int lineNumber = this.iv_currentIndex + 1;
            if (this.iv_delimeter != null) {
                int delimeterLoc = line.indexOf(this.iv_delimeter);
                if (delimeterLoc <= 0) {
                    throw new CollectionException((Throwable)new Exception("Line in file number " + lineNumber + " is not well formatted.  " + "\nIt should have the format:" + "\n<doc_id>" + this.iv_delimeter + "<doc_text>"));
                }
                id = line.substring(0, delimeterLoc);
                text = line.substring(delimeterLoc + this.iv_delimeter.length());
            } else {
                id = Integer.toString(lineNumber);
                text = line;
            }
            this.iv_logger.debug((Object)("id=" + id));
            this.iv_logger.debug((Object)("text=" + text));
            if (this.getCasInitializer() != null) {
                StringReader reader = new StringReader(text);
                this.getCasInitializer().initializeCas((Object)reader, cas);
                ((Reader)reader).close();
            } else {
                jcas.setDocumentText(text);
            }
            if (this.iv_language != null) {
                // empty if block
            }
            DocumentID documentIDAnnotation = new DocumentID(jcas);
            documentIDAnnotation.setDocumentID(id);
            documentIDAnnotation.addToIndexes();
        }
        catch (CASException e) {
            throw new CollectionException((Throwable)e);
        }
        finally {
            ++this.iv_currentIndex;
        }
    }

    public boolean hasNext() throws IOException, CollectionException {
        return this.iv_currentIndex < this.iv_linesFromFile.size();
    }

    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(this.iv_currentIndex, this.iv_linesFromFile.size(), "entities")};
    }

    public int getNumberOfDocuments() {
        return this.iv_linesFromFile.size();
    }

    public void close() throws IOException {
    }
}

