/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.pipeline;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.util.DocumentIDAnnotationUtil;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.log4j.Logger;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

public enum EntityCollector {
    INSTANCE;

    private static final Logger LOGGER;
    private final Map<String, Collection<Entity>> _entityMap = new HashMap<String, Collection<Entity>>();

    public static EntityCollector getInstance() {
        return INSTANCE;
    }

    public Collection<String> getDocumentIds() {
        return Collections.unmodifiableCollection(this._entityMap.keySet());
    }

    public Collection<Entity> getEntities(String documentId) {
        Collection<Entity> entities = this._entityMap.get(documentId);
        if (entities == null) {
            LOGGER.warn((Object)("No Entities for " + documentId));
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(entities);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Collection<Entity>> entry : this._entityMap.entrySet()) {
            sb.append(entry.getKey()).append("\n");
            entry.getValue().stream().sorted((e1, e2) -> ((Entity)e1)._begin - ((Entity)e2)._begin).map(Entity::toString).forEach(sb::append);
        }
        return sb.toString();
    }

    static {
        LOGGER = Logger.getLogger((String)"EntityCollector");
    }

    @PipeBitInfo(name="Entity Collector", description="Collects information on entities generated during a run.", role=PipeBitInfo.Role.SPECIAL, dependencies={PipeBitInfo.TypeProduct.DOCUMENT_ID, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION})
    public static final class EntityCollectorEngine
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) {
            LOGGER.info((Object)"Starting processing");
            String id = DocumentIDAnnotationUtil.getDeepDocumentId(jCas);
            Collection annotations = JCasUtil.select((JCas)jCas, IdentifiedAnnotation.class);
            EntityCollectorEngine.putEntities(id, annotations);
            LOGGER.info((Object)"Finished processing");
        }

        private static void putEntities(String documentId, Collection<IdentifiedAnnotation> annotations) {
            Collection entities = annotations.stream().map(x$0 -> new Entity((IdentifiedAnnotation)x$0)).collect(Collectors.toSet());
            EntityCollector.getInstance()._entityMap.put(documentId, entities);
        }
    }

    public static final class Entity {
        private final int _begin;
        private final int _end;
        private final String _coveredText;
        private final int _polarity;
        private final int _uncertainty;
        private final boolean _conditional;
        private final boolean _generic;
        private final String _subject;
        private final int _historyOf;

        private Entity(IdentifiedAnnotation annotation) {
            this._begin = annotation.getBegin();
            this._end = annotation.getEnd();
            this._coveredText = annotation.getCoveredText();
            this._polarity = annotation.getPolarity();
            this._uncertainty = annotation.getUncertainty();
            this._conditional = annotation.getConditional();
            this._generic = annotation.getGeneric();
            this._subject = annotation.getSubject();
            this._historyOf = annotation.getHistoryOf();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('\t').append(this._begin).append(',').append(this._end).append('\t').append(this._coveredText).append("\n");
            sb.append("\t\t| ").append(this._polarity < 0 ? "negated" : "affirmed");
            sb.append(" | ").append(this._uncertainty < 0 ? "uncertain" : "certain");
            sb.append(" | ").append(this._conditional ? "conditional" : "not conditional");
            sb.append(" | ").append(this._generic ? "generic" : "not generic");
            sb.append(" | ").append(this._subject == null ? "Patient" : this._subject);
            sb.append(" | history of: ").append(this._historyOf);
            sb.append('\n');
            return sb.toString();
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object other) {
            return this.toString().equals(other.toString());
        }
    }
}

