/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.smokingstatus.ae;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.ctakes.core.resource.FileResource;
import org.apache.ctakes.smokingstatus.Const;
import org.apache.ctakes.smokingstatus.type.NonSmokerNamedEntityAnnotation;
import org.apache.ctakes.smokingstatus.type.SmokerNamedEntityAnnotation;
import org.apache.ctakes.smokingstatus.type.libsvm.NominalAttributeValue;
import org.apache.ctakes.typesystem.type.syntax.WordToken;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorInitializationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;

public class ResolutionAnnotator {
    Set<String> conWords;
    public Logger iv_logger = Logger.getLogger((String)this.getClass().getName());
    private String apiMacroHome = "\\$main_root";

    public void initialize(UimaContext aContext) throws AnnotatorConfigurationException, AnnotatorInitializationException {
        this.conWords = new HashSet<String>();
        try {
            FileResource fResrc = (FileResource)aContext.getResourceObject("negationContradictionWordsKey");
            File conWordsFile = fResrc.getFile();
            this.conWords = this.readLinesFromFile(conWordsFile.getAbsolutePath());
        }
        catch (Exception ace) {
            throw new AnnotatorConfigurationException((Throwable)ace);
        }
    }

    public void process(JCas jcas) throws AnnotatorProcessException {
        String kuClassification = null;
        String pcsClassification = null;
        FSIterator navItr = jcas.getJFSIndexRepository().getAnnotationIndex(NominalAttributeValue.type).iterator();
        String navName = null;
        ArrayList<NominalAttributeValue> removalList = new ArrayList<NominalAttributeValue>();
        while (navItr.hasNext()) {
            NominalAttributeValue nav = (NominalAttributeValue)((Object)navItr.next());
            String string = nav.getNominalValue();
            if (string.equals("KNOWN") || string.equals("UNKNOWN")) {
                kuClassification = string;
                navName = nav.getAttributeName();
            } else if (string.equals("CURRENT_SMOKER") || string.equals("PAST_SMOKER") || string.equals("SMOKER")) {
                pcsClassification = string;
                navName = nav.getAttributeName();
            } else {
                throw new AnnotatorProcessException((Throwable)new Exception("Nominal value not part of " + Const.class + ": " + string));
            }
            removalList.add(nav);
        }
        for (TOP tOP : removalList) {
            tOP.removeFromIndexes();
        }
        int n = this.getSmokerNegatedCount(jcas);
        int nonsmokerCnt = this.getNonSmokerNegatedCount(jcas);
        int negConCnt = this.getNegConCount(jcas);
        String finalClassification = null;
        finalClassification = kuClassification.equals("UNKNOWN") ? kuClassification : (n > 0 && negConCnt == 0 || nonsmokerCnt > 0 ? "NON_SMOKER" : pcsClassification);
        if (this.iv_logger.isInfoEnabled() && finalClassification != "UNKNOWN") {
            for (Sentence sen : jcas.getJFSIndexRepository().getAnnotationIndex(Sentence.type)) {
                this.iv_logger.info((Object)("|" + sen.getCoveredText() + "|" + finalClassification + "|" + n));
            }
        }
        NominalAttributeValue finalNav = new NominalAttributeValue(jcas);
        finalNav.setAttributeName(navName);
        finalNav.setNominalValue(finalClassification);
        finalNav.addToIndexes();
    }

    private Set<String> readLinesFromFile(String fileName) throws IOException {
        String line;
        HashSet<String> returnValues = new HashSet<String>();
        File file = new File(fileName);
        BufferedReader fileReader = new BufferedReader(new FileReader(file));
        while ((line = fileReader.readLine()) != null) {
            line = line.toLowerCase();
            returnValues.add(line);
        }
        return returnValues;
    }

    private int getSmokerNegatedCount(JCas jcas) {
        int negCnt = 0;
        for (SmokerNamedEntityAnnotation neAnn : jcas.getJFSIndexRepository().getAnnotationIndex(SmokerNamedEntityAnnotation.type)) {
            int certainty = neAnn.getPolarity();
            if (certainty == -1) {
                ++negCnt;
            }
            this.iv_logger.info((Object)("***SmokerNameEntity***" + neAnn.getCoveredText() + " " + negCnt));
        }
        return negCnt;
    }

    private int getNonSmokerNegatedCount(JCas jcas) {
        int nonSmokerCnt = 0;
        for (NonSmokerNamedEntityAnnotation neAnn : jcas.getJFSIndexRepository().getAnnotationIndex(NonSmokerNamedEntityAnnotation.type)) {
            this.iv_logger.info((Object)("***NonSmokerNameEntity***" + neAnn.getCoveredText() + " " + ++nonSmokerCnt + " " + neAnn.getPolarity()));
        }
        return nonSmokerCnt;
    }

    private int getNegConCount(JCas jcas) {
        int conCnt = 0;
        for (WordToken token : jcas.getJFSIndexRepository().getAnnotationIndex(WordToken.type)) {
            String tok = token.getCoveredText();
            if (tok == null) continue;
            tok = tok.toLowerCase().replaceAll("[\\W]", " ").trim();
            String[] toks = tok.split("\\s");
            for (int i = 0; i < toks.length; ++i) {
                if (!this.conWords.contains(toks[i])) continue;
                ++conCnt;
            }
        }
        return conCnt;
    }
}

