/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.dkpro.core.api.resources;

import java.nio.ByteOrder;

public class PlatformDetector {
    public static String OS_WINDOWS = "windows";
    public static String OS_OSX = "osx";
    public static String OS_SOLARIS = "solaris";
    public static String OS_LINUX = "linux";
    public static String ARCH_PPC = "ppc";
    public static String ARCH_X86_32 = "x86_32";
    public static String ARCH_X86_64 = "x86_64";
    public static String ARCH_SPARC = "sparc";
    private String _arch = "";
    private String _os = "";
    private String _executableSuffix = "";
    private ByteOrder _byteOrder = ByteOrder.nativeOrder();
    private String[] _chmodCmd;

    public PlatformDetector() {
        this.updatePlatform(System.getProperties().getProperty("os.name"), System.getProperties().getProperty("os.arch"), ByteOrder.nativeOrder());
    }

    public void setOs(String aOs) {
        this.updatePlatform(aOs, this._arch, this._byteOrder);
    }

    public String getOs() {
        return this._os;
    }

    public void setArch(String aArch) {
        this.updatePlatform(this._os, aArch, this._byteOrder);
    }

    public String getArch() {
        return this._arch;
    }

    public void setByteOrder(ByteOrder aByteOrder) {
        this.updatePlatform(this._os, this._arch, aByteOrder);
    }

    public String getExecutableSuffix() {
        return this._executableSuffix;
    }

    public String getByteOrder() {
        return this._byteOrder.toString().replace("_", "-").toLowerCase();
    }

    public String getPlatformId() {
        return this._os + "-" + this._arch;
    }

    public void updatePlatform(String aOs, String aArch, ByteOrder aByteOrder) {
        this._os = aOs.toLowerCase();
        this._arch = aArch.toLowerCase();
        String[] chmod = new String[]{"chmod", "755", null};
        if (this._arch.equals("x86") || this._arch.equals("i386") || this._arch.equals("i486") || this._arch.equals("i586") || this._arch.equals("i686")) {
            this._arch = ARCH_X86_32;
        }
        if (this._arch.equals("amd64")) {
            this._arch = ARCH_X86_64;
        }
        if (this._arch.equals("powerpc")) {
            this._arch = ARCH_PPC;
        }
        if (this._os.startsWith("windows")) {
            this._os = OS_WINDOWS;
            this._executableSuffix = ".exe";
            chmod = null;
        }
        if (this._os.startsWith("mac")) {
            this._os = OS_OSX;
        }
        if (this._os.startsWith("linux")) {
            this._os = OS_LINUX;
        }
        if (this._os.startsWith("sun")) {
            this._os = OS_SOLARIS;
        }
        this._chmodCmd = chmod;
        this._byteOrder = aByteOrder;
    }

    public String[] getChmodCmd() {
        return this._chmodCmd;
    }
}

