/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.uima.mapper;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;

public class ISO8601Converter
implements Converter {
    private ThreadLocal<SimpleDateFormat> tlDateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        }
    };

    public Object convert(Class targetClass, Object input) throws ConversionException {
        if (!(input instanceof String)) {
            throw new ConversionException("input not a string: " + input.getClass());
        }
        try {
            Date dt = this.tlDateFormat.get().parse((String)input);
            if (targetClass.equals(Date.class)) {
                return dt;
            }
            if (targetClass.equals(Timestamp.class)) {
                return new Timestamp(dt.getTime());
            }
            throw new ConversionException("bad target type: " + targetClass.getName());
        }
        catch (ParseException e) {
            throw new ConversionException((Throwable)e);
        }
    }
}

