/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.experiment;

import com.googlecode.clearnlp.dependency.DEPArc;
import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.reader.SRLReader;
import com.googlecode.clearnlp.util.UTFile;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTOutput;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class ExtractVerbPredicates {
    final Pattern P_VERBS = Pattern.compile("VB.*");

    public ExtractVerbPredicates(String inputDir, String outputFile) {
        String[] inputFiles;
        PrintStream fout = UTOutput.createPrintBufferedFileStream(outputFile);
        SRLReader reader = new SRLReader(0, 1, 3, 5, 6, 8, 10, 12);
        for (String inputFile : inputFiles = UTFile.getSortedFileList(inputDir)) {
            DEPTree tree;
            reader.open(UTInput.createBufferedFileReader(inputFile));
            System.out.println(inputFile);
            while ((tree = reader.next()) != null) {
                if (!this.strip(tree)) continue;
                fout.println(tree.toStringSRL() + "\n");
            }
            reader.close();
        }
        fout.close();
    }

    public boolean strip(DEPTree tree) {
        Set<DEPNode> preds = this.getPredicates(tree);
        if (preds.isEmpty()) {
            return false;
        }
        int size = tree.size();
        for (int i = 1; i < size; ++i) {
            DEPNode node = tree.get(i);
            ArrayList<DEPArc> remove = new ArrayList<DEPArc>();
            for (DEPArc arc : node.getSHeads()) {
                if (preds.contains(arc.getNode())) continue;
                remove.add(arc);
            }
            node.removeSHeads(remove);
        }
        return true;
    }

    public Set<DEPNode> getPredicates(DEPTree tree) {
        HashSet<DEPNode> preds = new HashSet<DEPNode>();
        int size = tree.size();
        for (int i = 1; i < size; ++i) {
            DEPNode node = tree.get(i);
            if (node.getFeat("pb") != null && (this.P_VERBS.matcher(node.pos).find() || node.containsSHead("AM-PRR"))) {
                preds.add(node);
                continue;
            }
            node.removeFeat("pb");
        }
        return preds;
    }

    public static void main(String[] args) {
        new ExtractVerbPredicates(args[0], args[1]);
    }
}

