/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.run;

import com.googlecode.clearnlp.dependency.AbstractDEPParser;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.dependency.srl.AbstractSRLabeler;
import com.googlecode.clearnlp.engine.EngineGetter;
import com.googlecode.clearnlp.engine.EngineProcess;
import com.googlecode.clearnlp.morphology.AbstractMPAnalyzer;
import com.googlecode.clearnlp.pos.POSNode;
import com.googlecode.clearnlp.pos.POSTagger;
import com.googlecode.clearnlp.predicate.AbstractPredIdentifier;
import com.googlecode.clearnlp.reader.AbstractReader;
import com.googlecode.clearnlp.reader.DEPReader;
import com.googlecode.clearnlp.reader.LineReader;
import com.googlecode.clearnlp.reader.POSReader;
import com.googlecode.clearnlp.reader.RawReader;
import com.googlecode.clearnlp.reader.SRLReader;
import com.googlecode.clearnlp.reader.TOKReader;
import com.googlecode.clearnlp.run.AbstractRun;
import com.googlecode.clearnlp.segmentation.AbstractSegmenter;
import com.googlecode.clearnlp.tokenization.AbstractTokenizer;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTOutput;
import com.googlecode.clearnlp.util.UTXml;
import com.googlecode.clearnlp.util.pair.Pair;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.util.List;
import org.kohsuke.args4j.Option;
import org.w3c.dom.Element;

public class SRLPredict
extends AbstractRun {
    @Option(name="-i", usage="input path (required)", required=true, metaVar="<filepath>")
    private String s_inputPath;
    @Option(name="-ie", usage="input file extension (default: .*)", required=false, metaVar="<regex>")
    private String s_inputExt = ".*";
    @Option(name="-oe", usage="output file extension (default: labeled)", required=false, metaVar="<string>")
    private String s_outputExt = "labeled";
    @Option(name="-c", usage="configuration file (input; required)", required=true, metaVar="<filename>")
    private String s_configXml;
    @Option(name="-m", usage="model file (input; required)", required=true, metaVar="<filename>")
    private String s_modelFile;

    public SRLPredict() {
    }

    public SRLPredict(String[] args) {
        this.initArgs(args);
        try {
            Element eConfig = UTXml.getDocumentElement(new FileInputStream(this.s_configXml));
            List<String[]> filenames = this.getFilenames(this.s_inputPath, this.s_inputExt, this.s_outputExt);
            Pair<AbstractReader<?>, String> reader = this.getReader(eConfig);
            AbstractSegmenter segmenter = null;
            AbstractTokenizer tokenizer = null;
            Pair<POSTagger[], Double> taggers = null;
            AbstractMPAnalyzer analyzer = null;
            AbstractDEPParser parser = null;
            AbstractPredIdentifier identifier = null;
            if (((String)reader.o2).equals("raw")) {
                segmenter = this.getSegmenter(eConfig);
                taggers = this.getPOSTaggers(eConfig);
                analyzer = this.getMPAnalyzer(eConfig);
                parser = this.getDEPParser(eConfig);
                identifier = this.getPredIdentifier(eConfig);
            } else if (((String)reader.o2).equals("line")) {
                tokenizer = this.getTokenizer(eConfig);
                taggers = this.getPOSTaggers(eConfig);
                analyzer = this.getMPAnalyzer(eConfig);
                parser = this.getDEPParser(eConfig);
                identifier = this.getPredIdentifier(eConfig);
            } else if (((String)reader.o2).equals("tok")) {
                taggers = this.getPOSTaggers(eConfig);
                analyzer = this.getMPAnalyzer(eConfig);
                parser = this.getDEPParser(eConfig);
                identifier = this.getPredIdentifier(eConfig);
            } else if (((String)reader.o2).equals("pos")) {
                analyzer = this.getMPAnalyzer(eConfig);
                parser = this.getDEPParser(eConfig);
                identifier = this.getPredIdentifier(eConfig);
            } else if (((String)reader.o2).equals("dep")) {
                identifier = this.getPredIdentifier(eConfig);
            }
            AbstractSRLabeler labeler = EngineGetter.getSRLabeler(this.s_modelFile);
            for (String[] io : filenames) {
                if (((String)reader.o2).equals("raw")) {
                    this.predict(segmenter, taggers, analyzer, parser, identifier, labeler, (RawReader)reader.o1, io[0], io[1]);
                    continue;
                }
                if (((String)reader.o2).equals("line")) {
                    this.predict(tokenizer, taggers, analyzer, parser, identifier, labeler, (LineReader)reader.o1, io[0], io[1]);
                    continue;
                }
                if (((String)reader.o2).equals("tok")) {
                    this.predict(taggers, analyzer, parser, identifier, labeler, (TOKReader)reader.o1, io[0], io[1]);
                    continue;
                }
                if (((String)reader.o2).equals("pos")) {
                    this.predict(analyzer, parser, identifier, labeler, (POSReader)reader.o1, io[0], io[1]);
                    continue;
                }
                if (((String)reader.o2).equals("dep")) {
                    this.predict(identifier, labeler, (DEPReader)reader.o1, io[0], io[1]);
                    continue;
                }
                if (((String)reader.o2).equals("srl")) {
                    this.predict(labeler, (SRLReader)reader.o1, io[0], io[1]);
                    continue;
                }
                new Exception("Invalid reader type: " + (String)reader.o2);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void predict(AbstractSegmenter segmenter, Pair<POSTagger[], Double> taggers, AbstractMPAnalyzer analyzer, AbstractDEPParser parser, AbstractPredIdentifier identifier, AbstractSRLabeler labeler, RawReader fin, String inputFile, String outputFile) {
        PrintStream fout = UTOutput.createPrintBufferedFileStream(outputFile);
        fin.open(UTInput.createBufferedFileReader(inputFile));
        int i = 0;
        System.out.print(inputFile + ": ");
        for (List<String> tokens : segmenter.getSentences(fin.getBufferedReader())) {
            DEPTree tree = EngineProcess.getDEPTree(taggers, analyzer, parser, identifier, labeler, tokens);
            fout.println(tree.toStringSRL() + "\n");
            if (++i % 1000 != 0) continue;
            System.out.print(".");
        }
        System.out.println();
        fin.close();
        fout.close();
    }

    public void predict(AbstractTokenizer tokenizer, Pair<POSTagger[], Double> taggers, AbstractMPAnalyzer analyzer, AbstractDEPParser parser, AbstractPredIdentifier identifier, AbstractSRLabeler labeler, LineReader fin, String inputFile, String outputFile) {
        String line;
        PrintStream fout = UTOutput.createPrintBufferedFileStream(outputFile);
        fin.open(UTInput.createBufferedFileReader(inputFile));
        int i = 0;
        System.out.print(inputFile + ": ");
        while ((line = fin.next()) != null) {
            DEPTree tree = EngineProcess.getDEPTree(tokenizer, taggers, analyzer, parser, identifier, labeler, line);
            fout.println(tree.toStringSRL() + "\n");
            if (++i % 1000 != 0) continue;
            System.out.print(".");
        }
        System.out.println();
        fin.close();
        fout.close();
    }

    public void predict(Pair<POSTagger[], Double> taggers, AbstractMPAnalyzer analyzer, AbstractDEPParser parser, AbstractPredIdentifier identifier, AbstractSRLabeler labeler, TOKReader fin, String inputFile, String outputFile) {
        Object tokens;
        PrintStream fout = UTOutput.createPrintBufferedFileStream(outputFile);
        fin.open(UTInput.createBufferedFileReader(inputFile));
        int i = 0;
        System.out.print(inputFile + ": ");
        while ((tokens = fin.next()) != null) {
            DEPTree tree = EngineProcess.getDEPTree(taggers, analyzer, parser, identifier, labeler, (List<String>)tokens);
            fout.println(tree.toStringSRL() + "\n");
            if (++i % 1000 != 0) continue;
            System.out.print(".");
        }
        System.out.println();
        fin.close();
        fout.close();
    }

    public void predict(AbstractMPAnalyzer analyzer, AbstractDEPParser parser, AbstractPredIdentifier identifier, AbstractSRLabeler labeler, POSReader fin, String inputFile, String outputFile) {
        POSNode[] nodes;
        PrintStream fout = UTOutput.createPrintBufferedFileStream(outputFile);
        fin.open(UTInput.createBufferedFileReader(inputFile));
        int i = 0;
        System.out.print(inputFile + ": ");
        while ((nodes = fin.next()) != null) {
            DEPTree tree = EngineProcess.getDEPTree(analyzer, parser, identifier, labeler, nodes);
            fout.println(tree.toStringSRL() + "\n");
            if (++i % 1000 != 0) continue;
            System.out.print(".");
        }
        System.out.println();
        fin.close();
        fout.close();
    }

    public void predict(AbstractPredIdentifier identifier, AbstractSRLabeler labeler, DEPReader fin, String inputFile, String outputFile) {
        DEPTree tree;
        PrintStream fout = UTOutput.createPrintBufferedFileStream(outputFile);
        fin.open(UTInput.createBufferedFileReader(inputFile));
        int i = 0;
        System.out.print(inputFile + ": ");
        while ((tree = fin.next()) != null) {
            EngineProcess.predictSRL(identifier, labeler, tree);
            fout.println(tree.toStringSRL() + "\n");
            if (++i % 1000 != 0) continue;
            System.out.print(".");
        }
        System.out.println();
        fin.close();
        fout.close();
    }

    public void predict(AbstractSRLabeler labeler, SRLReader fin, String inputFile, String outputFile) {
        DEPTree tree;
        PrintStream fout = UTOutput.createPrintBufferedFileStream(outputFile);
        fin.open(UTInput.createBufferedFileReader(inputFile));
        int i = 0;
        System.out.print(inputFile + ": ");
        while ((tree = fin.next()) != null) {
            labeler.label(tree);
            fout.println(tree.toStringSRL() + "\n");
            if (++i % 1000 != 0) continue;
            System.out.print(".");
        }
        System.out.println();
        fin.close();
        fout.close();
    }

    public static void main(String[] args) {
        new SRLPredict(args);
    }
}

