/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.util;

import com.googlecode.clearnlp.io.FileExtFilter;
import com.googlecode.clearnlp.util.pair.StringLongPair;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class UTFile {
    public static String replaceExtension(String filename, String newExt) {
        int idx = filename.lastIndexOf(".");
        if (idx == -1) {
            return filename + "." + newExt;
        }
        return filename.substring(0, idx + 1) + newExt;
    }

    public static String replaceExtension(String filename, String oldExt, String newExt) {
        if (filename.endsWith(oldExt)) {
            return filename.substring(0, filename.length() - oldExt.length()) + newExt;
        }
        return filename;
    }

    public static String getBasename(String filepath) {
        int idx = filepath.lastIndexOf(File.separator);
        return filepath.substring(idx + 1);
    }

    public static String[] getSortedFileList(String fileDir) {
        return UTFile.getSortedFileList(fileDir, ".*");
    }

    public static String[] getSortedFileList(String fileDir, String fileExt) {
        ArrayList<String> list = new ArrayList<String>();
        for (String filepath : new File(fileDir).list(new FileExtFilter(fileExt))) {
            filepath = fileDir + File.separator + filepath;
            if (!new File(filepath).isFile()) continue;
            list.add(filepath);
        }
        Object[] filelist = new String[list.size()];
        list.toArray(filelist);
        Arrays.sort(filelist);
        return filelist;
    }

    public static String[] getSortedFileListBySize(String fileDir, String fileExt, boolean reverse) {
        ArrayList<StringLongPair> list = new ArrayList<StringLongPair>();
        for (String filepath : new File(fileDir).list(new FileExtFilter(fileExt))) {
            filepath = fileDir + File.separator + filepath;
            File file = new File(filepath);
            if (!file.isFile()) continue;
            list.add(new StringLongPair(filepath, file.length()));
        }
        int size = list.size();
        Collections.sort(list);
        String[] filelist = new String[size];
        for (int i = 0; i < size; ++i) {
            filelist[i] = ((StringLongPair)list.get((int)i)).s;
        }
        return filelist;
    }

    public static String[] getInputFileList(String inputPath, String inputExt) {
        File input = new File(inputPath);
        if (input.isDirectory()) {
            return UTFile.getSortedFileList(inputPath, inputExt);
        }
        return new String[]{inputPath};
    }
}

