/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.ShortArrayList;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.cursors.ShortCursor;

public class ShortStack
extends ShortArrayList {
    public ShortStack() {
    }

    public ShortStack(int initialCapacity) {
        super(initialCapacity);
    }

    public ShortStack(int initialCapacity, ArraySizingStrategy resizer) {
        super(initialCapacity, resizer);
    }

    public ShortStack(ShortContainer container) {
        super(container);
    }

    public final void push(short e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public final void push(short e1, short e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public final void push(short e1, short e2, short e3) {
        this.ensureBufferSpace(3);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
    }

    public final void push(short e1, short e2, short e3, short e4) {
        this.ensureBufferSpace(4);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
        this.buffer[this.elementsCount++] = e4;
    }

    public final void push(short[] elements, int start, int len) {
        assert (start >= 0 && len >= 0);
        this.ensureBufferSpace(len);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, len);
        this.elementsCount += len;
    }

    public final void push(short ... elements) {
        this.push(elements, 0, elements.length);
    }

    public final int pushAll(ShortContainer container) {
        return this.addAll(container);
    }

    public final int pushAll(Iterable<? extends ShortCursor> iterable) {
        return this.addAll(iterable);
    }

    public final void discard(int count) {
        assert (this.elementsCount >= count);
        this.elementsCount -= count;
    }

    public final void discard() {
        assert (this.elementsCount > 0);
        --this.elementsCount;
    }

    public final short pop() {
        assert (this.elementsCount > 0);
        short v = this.buffer[--this.elementsCount];
        return v;
    }

    public final short peek() {
        assert (this.elementsCount > 0);
        return this.buffer[this.elementsCount - 1];
    }

    public static ShortStack newInstance() {
        return new ShortStack();
    }

    public static ShortStack newInstanceWithCapacity(int initialCapacity) {
        return new ShortStack(initialCapacity);
    }

    public static ShortStack from(short ... elements) {
        ShortStack stack = new ShortStack(elements.length);
        stack.push(elements);
        return stack;
    }

    public static ShortStack from(ShortContainer container) {
        return new ShortStack(container);
    }

    @Override
    public ShortStack clone() {
        return (ShortStack)super.clone();
    }
}

