/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.ctakes.typesystem.type.syntax.WordToken;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;

public class ClosestVerbExtractor
implements FeatureExtractor1 {
    private String name = "ClosestVerb";

    public List<Feature> extract(JCas view, Annotation annotation) throws CleartkExtractorException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        Map coveringMap = JCasUtil.indexCovering((JCas)view, EventMention.class, Sentence.class);
        EventMention targetTokenAnnotation = (EventMention)annotation;
        Collection sentList = (Collection)coveringMap.get(targetTokenAnnotation);
        TreeMap<Integer, WordToken> verbDistMap = null;
        if (sentList != null && !sentList.isEmpty()) {
            for (Sentence sent : sentList) {
                verbDistMap = new TreeMap<Integer, WordToken>();
                for (WordToken wt : JCasUtil.selectCovered((JCas)view, WordToken.class, (AnnotationFS)sent)) {
                    String pos;
                    if (wt == null || !(pos = wt.getPartOfSpeech()).startsWith("VB")) continue;
                    verbDistMap.put(Math.abs(wt.getBegin() - annotation.getBegin()), wt);
                }
                Iterator<Object> iterator = verbDistMap.entrySet().iterator();
                if (!iterator.hasNext()) continue;
                Map.Entry entry = (Map.Entry)iterator.next();
                Feature feature = new Feature(this.name + "_token", (Object)((WordToken)entry.getValue()).getCoveredText());
                features.add(feature);
                Feature posfeature = new Feature(this.name, (Object)((WordToken)entry.getValue()).getPartOfSpeech());
                features.add(posfeature);
            }
        }
        return features;
    }
}

