/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.core.util.DocumentIDAnnotationUtil;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.relation.TemporalTextRelation;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.util.ViewUriUtil;

public class EventTimeRelationFeatureExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    private String cachedDocID = null;
    private Multimap<EventMention, String> eventSectionTimeRelationLookup;

    public List<Feature> extract(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        String docId = null;
        try {
            docId = ViewUriUtil.getURI((JCas)jCas).toString();
        }
        catch (Exception e) {
            docId = DocumentIDAnnotationUtil.getDocumentID((JCas)jCas);
        }
        if (!docId.equals(this.cachedDocID)) {
            this.cachedDocID = docId;
            this.rebuildCache(jCas);
        }
        ArrayList<Feature> feats = new ArrayList<Feature>();
        ArrayList events = Lists.newArrayList();
        if (arg1 instanceof EventMention) {
            events.add((EventMention)arg1);
        }
        if (arg2 instanceof EventMention) {
            events.add((EventMention)arg2);
        }
        for (EventMention event : events) {
            for (String value : this.eventSectionTimeRelationLookup.get((Object)event)) {
                feats.add(new Feature("hasEventTimeRelation_", (Object)value));
            }
        }
        return feats;
    }

    private void rebuildCache(JCas jCas) {
        TimeMention admissionTime = null;
        for (TimeMention time : JCasUtil.selectCovered((JCas)jCas, TimeMention.class, (int)15, (int)30)) {
            if (time.getTimeClass() == null || !time.getTimeClass().equals("DATE")) continue;
            admissionTime = time;
            break;
        }
        TimeMention dischargeTime = null;
        for (TimeMention time : JCasUtil.selectCovered((JCas)jCas, TimeMention.class, (int)40, (int)60)) {
            if (time.getTimeClass() == null || !time.getTimeClass().equals("DATE")) continue;
            dischargeTime = time;
            break;
        }
        this.eventSectionTimeRelationLookup = HashMultimap.create();
        for (TemporalTextRelation relation : JCasUtil.select((JCas)jCas, TemporalTextRelation.class)) {
            Annotation arg1 = relation.getArg1().getArgument();
            Annotation arg2 = relation.getArg2().getArgument();
            Annotation event = null;
            TimeMention time = null;
            if (arg1 instanceof EventMention && arg2 instanceof TimeMention) {
                event = arg1;
                time = (TimeMention)arg2;
            } else if (arg2 instanceof EventMention && arg1 instanceof TimeMention) {
                event = arg2;
                time = (TimeMention)arg1;
            }
            if (event == null || time == null) continue;
            if (time == admissionTime) {
                this.eventSectionTimeRelationLookup.put((Object)((EventMention)event), (Object)("admissionTime_" + relation.getCategory()));
                continue;
            }
            if (time == dischargeTime) {
                this.eventSectionTimeRelationLookup.put((Object)((EventMention)event), (Object)("dischargeTime_" + relation.getCategory()));
                continue;
            }
            this.eventSectionTimeRelationLookup.put((Object)((EventMention)event), (Object)(time.getTimeClass() + "_" + relation.getCategory()));
        }
    }
}

