/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.duration;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

public class PreserveUMLSEventTimeRelationsInGold
extends JCasAnnotator_ImplBase {
    public static final String GOLD_VIEW_NAME = "GoldView";
    public static final String SYSTEM_VIEW_NAME = "_InitialView";

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        JCas systemView;
        JCas goldView;
        try {
            goldView = jCas.getView(GOLD_VIEW_NAME);
        }
        catch (CASException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        try {
            systemView = jCas.getView(SYSTEM_VIEW_NAME);
        }
        catch (CASException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        for (BinaryTextRelation relation : Lists.newArrayList((Iterable)JCasUtil.select((JCas)goldView, BinaryTextRelation.class))) {
            List coveringSystemEventMentions;
            String eventText;
            String timeText;
            RelationArgument arg1 = relation.getArg1();
            RelationArgument arg2 = relation.getArg2();
            if (arg1.getArgument() instanceof TimeMention && arg2.getArgument() instanceof EventMention) {
                timeText = arg1.getArgument().getCoveredText().toLowerCase();
                eventText = arg2.getArgument().getCoveredText().toLowerCase();
                coveringSystemEventMentions = JCasUtil.selectCovered((JCas)systemView, EventMention.class, (int)arg2.getArgument().getBegin(), (int)arg2.getArgument().getEnd());
            } else {
                if (!(arg1.getArgument() instanceof EventMention) || !(arg2.getArgument() instanceof TimeMention)) continue;
                eventText = arg1.getArgument().getCoveredText().toLowerCase();
                timeText = arg2.getArgument().getCoveredText().toLowerCase();
                coveringSystemEventMentions = JCasUtil.selectCovered((JCas)systemView, EventMention.class, (int)arg1.getArgument().getBegin(), (int)arg1.getArgument().getEnd());
            }
            if (coveringSystemEventMentions.size() > 0) {
                System.out.println("keeping: " + timeText + "-" + eventText);
                continue;
            }
            System.out.println("removing: " + timeText + "-" + eventText);
            arg1.removeFromIndexes();
            arg2.removeFromIndexes();
            relation.removeFromIndexes();
        }
        for (EventMention mention : Lists.newArrayList((Iterable)JCasUtil.select((JCas)goldView, EventMention.class))) {
            List coveringSystemEventMentions = JCasUtil.selectCovered((JCas)systemView, EventMention.class, (int)mention.getBegin(), (int)mention.getEnd());
            if (coveringSystemEventMentions.size() > 0) continue;
            mention.removeFromIndexes();
        }
    }
}

