/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.attributes.subject;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.ctakes.dependency.parser.util.DependencyPath;
import org.apache.ctakes.dependency.parser.util.DependencyUtility;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.Predicate;
import org.apache.ctakes.typesystem.type.textsem.SemanticArgument;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class SubjectAttributeClassifier {
    public static final String DONOR_TOKEN = "donor_token";
    public static final String DONOR_SRLARG = "donor_srlarg";
    public static final String DONOR_DEPPATH = "donor_deppath";
    public static final String DONOR_DEPTOK = "donor_depsrl";
    public static final String DONOR_OR = "donor_or";
    public static final String FAMILY_TOKEN = "family_token";
    public static final String FAMILY_SRLARG = "family_srlarg";
    public static final String FAMILY_DEPPATH = "family_deppath";
    public static final String FAMILY_DEPTOK = "family_depsrl";
    public static final String FAMILY_OR = "family_or";
    public static final String OTHER_TOKEN = "other_token";
    public static final String OTHER_SRLARG = "other_srlarg";
    public static final String OTHER_DEPPATH = "other_deppath";
    public static final String OTHER_DEPTOK = "other_depsrl";
    public static final String OTHER_OR = "other_or";
    public static ArrayList<String> FeatureIndex = new ArrayList();
    private static Logger logger = Logger.getLogger(SubjectAttributeClassifier.class);

    public static String getSubject(JCas jCas, IdentifiedAnnotation mention) {
        HashMap<String, Boolean> vfeat = SubjectAttributeClassifier.extract(jCas, (Annotation)mention);
        return SubjectAttributeClassifier.classifyWithLogic(vfeat);
    }

    public static HashMap<String, Boolean> extract(JCas jCas, Annotation mention) {
        HashMap<String, Boolean> vfeat = new HashMap<String, Boolean>();
        for (String feat : FeatureIndex) {
            vfeat.put(feat, false);
        }
        Object sEntity = null;
        Collection sentences = JCasUtil.select((JCas)jCas, Sentence.class);
        for (Object s : sentences) {
            if (s.getBegin() > mention.getBegin() || s.getEnd() < mention.getEnd()) continue;
            sEntity = s;
            break;
        }
        if (sEntity == null) {
            return new HashMap<String, Boolean>();
        }
        List args = JCasUtil.selectCovered((JCas)jCas, SemanticArgument.class, sEntity);
        for (SemanticArgument arg : args) {
            if (!arg.getLabel().matches("A[01]")) continue;
            if (SubjectAttributeClassifier.isDonorTerm((Annotation)arg)) {
                vfeat.put(DONOR_SRLARG, true);
            }
            if (SubjectAttributeClassifier.isFamilyTerm((Annotation)arg)) {
                vfeat.put(FAMILY_SRLARG, true);
            }
            if (!SubjectAttributeClassifier.isOtherTerm((Annotation)arg)) continue;
            vfeat.put(OTHER_SRLARG, true);
        }
        List preds = JCasUtil.selectCovered((JCas)jCas, Predicate.class, (AnnotationFS)sEntity);
        List depnodes = JCasUtil.selectCovered((JCas)jCas, ConllDependencyNode.class, (AnnotationFS)mention);
        if (!depnodes.isEmpty()) {
            ConllDependencyNode depnode = DependencyUtility.getNominalHeadNode((List)depnodes);
            for (ConllDependencyNode dn : DependencyUtility.getPathToTop((JCas)jCas, (ConllDependencyNode)depnode)) {
                if (SubjectAttributeClassifier.isDonorTerm((Annotation)dn)) {
                    vfeat.put(DONOR_DEPPATH, true);
                }
                if (SubjectAttributeClassifier.isFamilyTerm((Annotation)dn)) {
                    vfeat.put(FAMILY_DEPPATH, true);
                }
                if (!SubjectAttributeClassifier.isOtherTerm((Annotation)dn)) continue;
                vfeat.put(OTHER_DEPPATH, true);
            }
        }
        List toks = JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)sEntity);
        for (BaseToken tok : toks) {
            int commonInd;
            DependencyPath path;
            if (SubjectAttributeClassifier.isDonorTerm((Annotation)tok)) {
                vfeat.put(DONOR_TOKEN, true);
                path = DependencyUtility.getPath((JCas)jCas, (ConllDependencyNode)DependencyUtility.getNominalHeadNode((JCas)jCas, (Annotation)tok), (ConllDependencyNode)DependencyUtility.getNominalHeadNode((JCas)jCas, (Annotation)mention));
                commonInd = path.indexOf((Object)path.getCommonNode());
                if (commonInd == 1 || commonInd == path.size() - 2) {
                    vfeat.put(DONOR_DEPTOK, true);
                }
            }
            if (SubjectAttributeClassifier.isFamilyTerm((Annotation)tok)) {
                vfeat.put(FAMILY_TOKEN, true);
                path = DependencyUtility.getPath((JCas)jCas, (ConllDependencyNode)DependencyUtility.getNominalHeadNode((JCas)jCas, (Annotation)tok), (ConllDependencyNode)DependencyUtility.getNominalHeadNode((JCas)jCas, (Annotation)mention));
                if (path != null && ((commonInd = path.indexOf((Object)path.getCommonNode())) == 1 || commonInd == path.size() - 2)) {
                    vfeat.put(FAMILY_DEPTOK, true);
                }
            }
            if (!SubjectAttributeClassifier.isOtherTerm((Annotation)tok)) continue;
            vfeat.put(OTHER_TOKEN, true);
            path = DependencyUtility.getPath((JCas)jCas, (ConllDependencyNode)DependencyUtility.getNominalHeadNode((JCas)jCas, (Annotation)tok), (ConllDependencyNode)DependencyUtility.getNominalHeadNode((JCas)jCas, (Annotation)mention));
            commonInd = path.indexOf((Object)path.getCommonNode());
            if (commonInd != 1 && commonInd != path.size() - 2) continue;
            vfeat.put(OTHER_DEPTOK, true);
        }
        return vfeat;
    }

    public static String classifyWithLogic(HashMap<String, Boolean> vfeat) {
        if (vfeat == null) {
            logger.warn((Object)"Subject attribute classifier missing feature values, defaulting to 'patient'");
            return "patient";
        }
        Boolean donor_summary = new Boolean(vfeat.get(DONOR_TOKEN) != false || vfeat.get(DONOR_DEPPATH) != false || vfeat.get(DONOR_DEPTOK) != false || vfeat.get(DONOR_SRLARG) != false);
        Boolean family_summary = new Boolean(vfeat.get(FAMILY_DEPPATH) != false || vfeat.get(FAMILY_DEPTOK) != false || vfeat.get(FAMILY_SRLARG) != false);
        Boolean other_summary = new Boolean(vfeat.get(OTHER_DEPPATH) != false || vfeat.get(OTHER_DEPTOK) != false || vfeat.get(OTHER_SRLARG) != false);
        vfeat.put(DONOR_OR, donor_summary);
        vfeat.put(FAMILY_OR, family_summary);
        vfeat.put(OTHER_OR, other_summary);
        if (vfeat.get(DONOR_OR).booleanValue() && vfeat.get(FAMILY_OR).booleanValue()) {
            return "donor_family_member";
        }
        if (vfeat.get(DONOR_OR).booleanValue() && !vfeat.get(FAMILY_OR).booleanValue()) {
            return "donor_other";
        }
        if (!vfeat.get(DONOR_OR).booleanValue() && !vfeat.get(FAMILY_OR).booleanValue() && vfeat.get(OTHER_OR).booleanValue()) {
            return "other";
        }
        if (!vfeat.get(DONOR_OR).booleanValue() && vfeat.get(FAMILY_OR).booleanValue()) {
            return "family_member";
        }
        return "patient";
    }

    public static boolean isDonorTerm(Annotation arg) {
        return arg.getCoveredText().toLowerCase().matches("(donor).*");
    }

    public static boolean isFamilyTerm(Annotation arg) {
        return arg.getCoveredText().toLowerCase().matches("(father|dad|mother|mom|bro|sis|sib|cousin|aunt|uncle|grandm|grandp|grandf|wife|spouse|husband|child|offspring|progeny|son|daughter|nephew|niece|kin|family).*");
    }

    public static boolean isOtherTerm(Annotation arg) {
        return arg.getCoveredText().toLowerCase().matches(".*(in-law|stepc|stepd|stepso|stepf|stepm|step-).*");
    }

    public static void main(String[] args) {
        String s = "steps";
        if (s.toLowerCase().matches(".*(in-law|stepc|stepd|stepso|stepf|stepm|step-).*")) {
            System.out.println("match");
        } else {
            System.out.println("no match");
        }
    }

    static {
        FeatureIndex.add(DONOR_TOKEN);
        FeatureIndex.add(DONOR_SRLARG);
        FeatureIndex.add(DONOR_DEPPATH);
        FeatureIndex.add(DONOR_DEPTOK);
        FeatureIndex.add(DONOR_OR);
        FeatureIndex.add(FAMILY_TOKEN);
        FeatureIndex.add(FAMILY_SRLARG);
        FeatureIndex.add(FAMILY_DEPPATH);
        FeatureIndex.add(FAMILY_DEPTOK);
        FeatureIndex.add(FAMILY_OR);
        FeatureIndex.add(OTHER_TOKEN);
        FeatureIndex.add(OTHER_SRLARG);
        FeatureIndex.add(OTHER_DEPPATH);
        FeatureIndex.add(OTHER_DEPTOK);
        FeatureIndex.add(OTHER_OR);
    }
}

