/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.medfacts.cleartk;

import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.ctakes.assertion.eval.AssertionEvaluation;
import org.apache.ctakes.assertion.medfacts.cleartk.AssertionCleartkAnalysisEngine;
import org.apache.ctakes.assertion.medfacts.cleartk.AssertionComponents;
import org.apache.ctakes.core.cc.XmiWriterCasConsumerCtakes;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.factory.ConfigurationParameterFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.testing.util.HideOutput;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.cleartk.ml.jar.Train;
import org.cleartk.ml.opennlp.maxent.MaxentStringOutcomeDataWriter;
import org.cleartk.util.cr.XReader;

public class TrainAssertionModel {
    public static final String PARAM_NAME_DECODING_OUTPUT_DIRECTORY = "decoding-output-directory";
    public static final String PARAM_NAME_DECODING_INPUT_DIRECTORY = "decoding-input-directory";
    public static final String PARAM_NAME_TRAINING_INPUT_DIRECTORY = "training-input-directory";
    public static final String PARAM_NAME_MODEL_DIRECTORY = "model-directory";
    protected static final Logger logger = Logger.getLogger((String)TrainAssertionModel.class.getName());
    protected String modelOutputDirectory = "/work/medfacts/cleartk/data/train.model";

    public void testMaxent() throws Exception {
        String trainingDataDirectory = "/work/medfacts/cleartk/data/train";
        String evaluationDataDirectory = "/work/medfacts/cleartk/data/eval2.input";
        String evaluationOutputDataDirectory = "/work/medfacts/cleartk/data/eval2.output";
        String maxentModelOutputDirectory = this.modelOutputDirectory + "/maxent";
        AnalysisEngineDescription dataWriter = AnalysisEngineFactory.createEngineDescription(AssertionCleartkAnalysisEngine.class, (TypeSystemDescription)AssertionComponents.CTAKES_CTS_TYPE_SYSTEM_DESCRIPTION, (Object[])new Object[]{"dataWriterClassName", MaxentStringOutcomeDataWriter.class.getName(), "outputDirectory", maxentModelOutputDirectory});
        TrainAssertionModel.testClassifier(dataWriter, maxentModelOutputDirectory, trainingDataDirectory, evaluationDataDirectory, evaluationOutputDataDirectory, new String[0]);
    }

    public static void main(String[] args) {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)PARAM_NAME_MODEL_DIRECTORY);
        OptionBuilder.withArgName((String)"DIR");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"the directory where the model is written to for training, or read from for decoding");
        Option modelDirectoryOption = OptionBuilder.create();
        options.addOption(modelDirectoryOption);
        OptionBuilder.withLongOpt((String)PARAM_NAME_TRAINING_INPUT_DIRECTORY);
        OptionBuilder.withArgName((String)"DIR");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"directory where input training xmi files are located");
        Option trainingInputDirectoryOption = OptionBuilder.create();
        options.addOption(trainingInputDirectoryOption);
        OptionBuilder.withLongOpt((String)PARAM_NAME_DECODING_INPUT_DIRECTORY);
        OptionBuilder.withArgName((String)"DIR");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"directory where input xmi files are located for decoding");
        Option decodingInputDirectoryOption = OptionBuilder.create();
        options.addOption(decodingInputDirectoryOption);
        OptionBuilder.withLongOpt((String)PARAM_NAME_DECODING_OUTPUT_DIRECTORY);
        OptionBuilder.withArgName((String)"DIR");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"directory where output xmi files that are generated in decoding are placed");
        Option decodingOutputDirectoryOption = OptionBuilder.create();
        options.addOption(decodingOutputDirectoryOption);
        GnuParser parser = new GnuParser();
        boolean invalidInput = false;
        CommandLine commandLine = null;
        String modelDirectory = null;
        String trainingInputDirectory = null;
        String decodingInputDirectory = null;
        String decodingOutputDirectory = null;
        try {
            commandLine = parser.parse(options, args);
            modelDirectory = commandLine.getOptionValue(PARAM_NAME_MODEL_DIRECTORY);
            trainingInputDirectory = commandLine.getOptionValue(PARAM_NAME_TRAINING_INPUT_DIRECTORY);
            decodingInputDirectory = commandLine.getOptionValue(PARAM_NAME_DECODING_INPUT_DIRECTORY);
            decodingOutputDirectory = commandLine.getOptionValue(PARAM_NAME_DECODING_OUTPUT_DIRECTORY);
        }
        catch (ParseException e) {
            invalidInput = true;
            logger.error((Object)"unable to parse command-line arguments", (Throwable)e);
        }
        if (modelDirectory == null || modelDirectory.isEmpty() || trainingInputDirectory == null || trainingInputDirectory.isEmpty() || decodingInputDirectory == null || decodingInputDirectory.isEmpty() || decodingOutputDirectory == null || decodingOutputDirectory.isEmpty()) {
            logger.error((Object)"required parameters not supplied");
            invalidInput = true;
        }
        if (invalidInput) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(TrainAssertionModel.class.getName(), options, true);
            return;
        }
        logger.info((Object)String.format("%nmodel dir:           \"%s\"%ntraining input dir:  \"%s\"%ndecoding input dir:  \"%s\"%ndecoding output dir: \"%s\"%n", modelDirectory, trainingInputDirectory, decodingInputDirectory, decodingOutputDirectory));
        String maxentModelOutputDirectory = modelDirectory + "/maxent";
        try {
            AnalysisEngineDescription dataWriter = AnalysisEngineFactory.createEngineDescription(AssertionCleartkAnalysisEngine.class, (TypeSystemDescription)AssertionComponents.CTAKES_CTS_TYPE_SYSTEM_DESCRIPTION, (Object[])new Object[]{"dataWriterClassName", MaxentStringOutcomeDataWriter.class.getName(), "outputDirectory", maxentModelOutputDirectory});
            TrainAssertionModel.testClassifier(dataWriter, maxentModelOutputDirectory, trainingInputDirectory, decodingInputDirectory, decodingOutputDirectory, new String[0]);
        }
        catch (Exception e) {
            logger.error((Object)"Some exception happened while training or decoding...", (Throwable)e);
            return;
        }
    }

    public static void testClassifier(AnalysisEngineDescription dataWriter, String modelOutputDirectory, String trainingDataInputDirectory, String decodingInputDirectory, String decodingOutputDirectory, String ... trainingArgs) throws Exception {
        String[] args;
        CollectionReader trainingCollectionReader = CollectionReaderFactory.createReader(XReader.class, (Object[])new Object[]{"rootFile", trainingDataInputDirectory, "xmlScheme", "XMI"});
        CollectionReader evaluationCollectionReader = CollectionReaderFactory.createReader(XReader.class, (Object[])new Object[]{"rootFile", decodingInputDirectory, "xmlScheme", "XMI"});
        AggregateBuilder trainingBuilder = new AggregateBuilder();
        AnalysisEngineDescription goldCopierAnnotator = AnalysisEngineFactory.createEngineDescription(AssertionEvaluation.ReferenceIdentifiedAnnotationsSystemToGoldCopier.class, (Object[])new Object[0]);
        trainingBuilder.add(goldCopierAnnotator, new String[0]);
        AnalysisEngineDescription assertionAttributeClearerAnnotator = AnalysisEngineFactory.createEngineDescription(AssertionEvaluation.ReferenceAnnotationsSystemAssertionClearer.class, (Object[])new Object[0]);
        trainingBuilder.add(assertionAttributeClearerAnnotator, new String[0]);
        AnalysisEngineDescription trainingAssertionAnnotator = AnalysisEngineFactory.createEngineDescription(AssertionCleartkAnalysisEngine.class, (TypeSystemDescription)AssertionComponents.CTAKES_CTS_TYPE_SYSTEM_DESCRIPTION, (Object[])new Object[0]);
        ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)trainingAssertionAnnotator, (Object[])new Object[]{"GoldViewName", "GoldView", "outputDirectory", modelOutputDirectory});
        trainingBuilder.add(trainingAssertionAnnotator, new String[0]);
        logger.info((Object)"starting feature generation...");
        SimplePipeline.runPipeline((CollectionReader)trainingCollectionReader, (AnalysisEngineDescription[])new AnalysisEngineDescription[]{trainingBuilder.createAggregateDescription()});
        logger.info((Object)"finished feature generation.");
        if (trainingArgs != null && trainingArgs.length > 0) {
            args = new String[trainingArgs.length + 1];
            args[0] = modelOutputDirectory;
            System.arraycopy(trainingArgs, 0, args, 1, trainingArgs.length);
        } else {
            args = new String[]{modelOutputDirectory};
        }
        HideOutput hider = new HideOutput();
        logger.info((Object)"starting training...");
        Train.main((String[])args);
        logger.info((Object)"finished training.");
        hider.restoreOutput();
        AggregateBuilder decodingBuilder = new AggregateBuilder();
        decodingBuilder.add(goldCopierAnnotator, new String[0]);
        decodingBuilder.add(assertionAttributeClearerAnnotator, new String[0]);
        AnalysisEngineDescription decodingAssertionAnnotator = AnalysisEngineFactory.createEngineDescription(AssertionCleartkAnalysisEngine.class, (TypeSystemDescription)AssertionComponents.CTAKES_CTS_TYPE_SYSTEM_DESCRIPTION, (Object[])new Object[0]);
        ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)decodingAssertionAnnotator, (Object[])new Object[]{"GoldViewName", "GoldView", "classifierJarPath", new File(modelOutputDirectory, "model.jar").getPath()});
        decodingBuilder.add(decodingAssertionAnnotator, new String[0]);
        AnalysisEngineDescription decodingAggregateDescription = decodingBuilder.createAggregateDescription();
        logger.info((Object)"starting decoding...");
        SimplePipeline.runPipeline((CollectionReader)evaluationCollectionReader, (AnalysisEngineDescription[])new AnalysisEngineDescription[]{decodingAggregateDescription, AnalysisEngineFactory.createEngineDescription(XmiWriterCasConsumerCtakes.class, (TypeSystemDescription)AssertionComponents.CTAKES_CTS_TYPE_SYSTEM_DESCRIPTION, (Object[])new Object[]{"OutputDirectory", decodingOutputDirectory})});
        logger.info((Object)"finished decoding.");
    }
}

