/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel.metric;

import java.util.Map;
import org.apache.ctakes.ytex.kernel.metric.BaseSimilarityMetric;
import org.apache.ctakes.ytex.kernel.metric.ConceptSimilarityService;
import org.apache.ctakes.ytex.kernel.metric.SimilarityInfo;

public class LCHMetric
extends BaseSimilarityMetric {
    double logdm = 0.0;

    @Override
    public double similarity(String concept1, String concept2, Map<String, Double> conceptFilter, SimilarityInfo simInfo) {
        if (this.logdm != 0.0) {
            this.initLCSes(concept1, concept2, simInfo);
            if (simInfo.getLcsDist() > 0) {
                return 1.0 - Math.log(simInfo.getLcsDist().intValue()) / this.logdm;
            }
        }
        return 0.0;
    }

    public LCHMetric(ConceptSimilarityService simSvc, Integer maxDepth) {
        super(simSvc);
        if (maxDepth != null) {
            this.logdm = Math.log(2 * maxDepth);
        }
    }
}

