/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.umls.dao;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.ytex.umls.dao.UMLSDao;
import org.apache.ctakes.ytex.umls.model.UmlsAuiFirstWord;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class UMLSDaoImpl
implements UMLSDao {
    public static final String[] INCLUDE_REL = new String[]{"PAR"};
    public static final String[] EXCLUDE_RELA = new String[]{"inverse_isa"};
    private static final Log log = LogFactory.getLog(UMLSDaoImpl.class);
    SessionFactory sessionFactory;
    private JdbcTemplate t;

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setDataSource(DataSource ds) {
        this.t = new JdbcTemplate(ds);
    }

    public DataSource getDataSource() {
        return this.t.getDataSource();
    }

    @Override
    public List<Object[]> getAllAuiStr(String lastAui) {
        Query q = null;
        if (lastAui == null) {
            q = this.sessionFactory.getCurrentSession().getNamedQuery("getFirstAuiStr");
        } else {
            q = this.sessionFactory.getCurrentSession().getNamedQuery("getNextAuiStr");
            q.setString("aui", lastAui);
        }
        q.setMaxResults(10000);
        return q.list();
    }

    @Override
    public void deleteAuiFirstWord() {
        this.sessionFactory.getCurrentSession().createQuery("delete from UmlsAuiFirstWord").executeUpdate();
    }

    @Override
    public void insertAuiFirstWord(List<UmlsAuiFirstWord> listAuiFirstWord) {
        for (UmlsAuiFirstWord w : listAuiFirstWord) {
            this.sessionFactory.getCurrentSession().save((Object)w);
        }
    }

    @Override
    public Map<String, String> getNames(List<String> subList) {
        HashMap<String, String> names = new HashMap<String, String>(subList.size());
        this.updateNames("getCuiMinStr", subList, names);
        this.updateNames("getCuiPreferredName", subList, names);
        return names;
    }

    private void updateNames(String queryName, List<String> subList, Map<String, String> names) {
        Query q = this.sessionFactory.getCurrentSession().getNamedQuery(queryName);
        q.setParameterList("cuis", subList);
        List listCuiName = q.list();
        for (Object[] cuiName : listCuiName) {
            names.put((String)cuiName[0], (String)cuiName[1]);
        }
    }

    @Override
    public String getLastAui() {
        Query q = this.sessionFactory.getCurrentSession().getNamedQuery("getLastAui");
        String aui = (String)q.uniqueResult();
        return aui;
    }

    @Override
    public HashSet<Integer> getRXNORMCuis() {
        HashSet<Integer> cuis = new HashSet<Integer>();
        for (String cui : this.sessionFactory.getCurrentSession().getNamedQuery("getRXNORMCuis").list()) {
            Matcher m = UMLSDao.cuiPattern.matcher(cui);
            if (!m.find()) continue;
            cuis.add(Integer.parseInt(m.group(1)));
        }
        return cuis;
    }

    @Override
    public boolean isRXNORMCui(String cui) {
        Query q = this.sessionFactory.getCurrentSession().getNamedQuery("isRXNORMCui");
        q.setCacheable(true);
        q.setString("cui", cui);
        long count = (Long)q.uniqueResult();
        return count > 0L;
    }
}

