/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup.ae;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.ctakes.dictionary.lookup.DictionaryException;
import org.apache.ctakes.dictionary.lookup.MetaDataHit;
import org.apache.ctakes.dictionary.lookup.ae.BaseLookupConsumerImpl;
import org.apache.ctakes.dictionary.lookup.vo.LookupHit;
import org.apache.ctakes.typesystem.type.refsem.UmlsConcept;
import org.apache.ctakes.typesystem.type.textsem.AnatomicalSiteMention;
import org.apache.ctakes.typesystem.type.textsem.DiseaseDisorderMention;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.LabMention;
import org.apache.ctakes.typesystem.type.textsem.MedicationMention;
import org.apache.ctakes.typesystem.type.textsem.ProcedureMention;
import org.apache.ctakes.typesystem.type.textsem.SignSymptomMention;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;

public abstract class UmlsToSnomedConsumerImpl
extends BaseLookupConsumerImpl {
    private static final String CUI_MF_PRP_KEY = "cuiMetaField";
    private static final String TUI_MF_PRP_KEY = "tuiMetaField";
    private static final String CODING_SCHEME_PRP_KEY = "codingScheme";
    private static final String MEDICATION_TUIS_PRP_KEY = "medicationTuis";
    private static final String ANT_SITE_TUIS_PRP_KEY = "anatomicalSiteTuis";
    private static final String PROCEDURE_TUIS_PRP_KEY = "procedureTuis";
    private static final String DISORDER_TUIS_PRP_KEY = "disorderTuis";
    private static final String FINDING_TUIS_PRP_KEY = "findingTuis";
    private Set<String> _medicationSet = new HashSet<String>();
    private Set<String> _antSiteTuiSet = new HashSet<String>();
    private Set<String> _procedureTuiSet = new HashSet<String>();
    private Set<String> _disorderTuiSet = new HashSet<String>();
    private Set<String> _findingTuiSet = new HashSet<String>();
    private Set<String> _validTuiSet = new HashSet<String>();
    protected Properties props;

    public UmlsToSnomedConsumerImpl(UimaContext aCtx, Properties properties) throws Exception {
        this.props = properties;
        this._medicationSet = UmlsToSnomedConsumerImpl.loadList(this.props.getProperty(MEDICATION_TUIS_PRP_KEY));
        this._antSiteTuiSet = UmlsToSnomedConsumerImpl.loadList(this.props.getProperty(ANT_SITE_TUIS_PRP_KEY));
        this._procedureTuiSet = UmlsToSnomedConsumerImpl.loadList(this.props.getProperty(PROCEDURE_TUIS_PRP_KEY));
        this._disorderTuiSet = UmlsToSnomedConsumerImpl.loadList(this.props.getProperty(DISORDER_TUIS_PRP_KEY));
        this._findingTuiSet = UmlsToSnomedConsumerImpl.loadList(this.props.getProperty(FINDING_TUIS_PRP_KEY));
        this._validTuiSet.addAll(this._medicationSet);
        this._validTuiSet.addAll(this._antSiteTuiSet);
        this._validTuiSet.addAll(this._procedureTuiSet);
        this._validTuiSet.addAll(this._disorderTuiSet);
        this._validTuiSet.addAll(this._findingTuiSet);
    }

    protected abstract Set<String> getSnomedCodes(String var1) throws SQLException, DictionaryException;

    @Override
    public void consumeHits(JCas jcas, Iterator<LookupHit> lhItr) throws AnalysisEngineProcessException {
        try {
            String cuiPropKey = this.props.getProperty(CUI_MF_PRP_KEY);
            String tuiPropKey = this.props.getProperty(TUI_MF_PRP_KEY);
            Map<BaseLookupConsumerImpl.LookupHitKey, Set<LookupHit>> lookupHitMap = UmlsToSnomedConsumerImpl.createLookupHitMap(lhItr);
            for (Map.Entry<BaseLookupConsumerImpl.LookupHitKey, Set<LookupHit>> entry : lookupHitMap.entrySet()) {
                Object cuiTuiKey;
                int neBegin = entry.getKey().__start;
                int neEnd = entry.getKey().__end;
                HashSet<String> cuiTuiSet = new HashSet<String>();
                HashMap conceptMap = new HashMap();
                for (LookupHit lookupHit : entry.getValue()) {
                    Set<UmlsConcept> conceptSet;
                    MetaDataHit mdh = lookupHit.getDictMetaDataHit();
                    String cui = mdh.getMetaFieldValue(cuiPropKey);
                    String tui = mdh.getMetaFieldValue(tuiPropKey);
                    if (!this._validTuiSet.contains(tui) || cuiTuiSet.contains(cuiTuiKey = UmlsToSnomedConsumerImpl.getUniqueKey(cui, tui))) continue;
                    cuiTuiSet.add((String)cuiTuiKey);
                    Set<String> snomedCodeSet = this.getSnomedCodes(cui);
                    if (snomedCodeSet.isEmpty()) continue;
                    Integer neType = this.getNamedEntityType(tui);
                    if (conceptMap.containsKey(neType)) {
                        conceptSet = (Set)conceptMap.get(neType);
                    } else {
                        conceptSet = new HashSet();
                        conceptMap.put(neType, conceptSet);
                    }
                    Collection<UmlsConcept> conceptCol = this.createConceptCol(jcas, cui, tui, snomedCodeSet);
                    conceptSet.addAll(conceptCol);
                }
                for (Map.Entry entry2 : conceptMap.entrySet()) {
                    Set conceptSet = (Set)entry2.getValue();
                    if (conceptSet.isEmpty()) continue;
                    FSArray conceptArr = new FSArray(jcas, conceptSet.size());
                    int arrIdx = 0;
                    cuiTuiKey = conceptSet.iterator();
                    while (cuiTuiKey.hasNext()) {
                        UmlsConcept umlsConcept = (UmlsConcept)cuiTuiKey.next();
                        conceptArr.set(arrIdx, (FeatureStructure)umlsConcept);
                        ++arrIdx;
                    }
                    int conceptKey = (Integer)entry2.getKey();
                    Object neAnnot = conceptKey == 1 ? new MedicationMention(jcas) : (conceptKey == 6 ? new AnatomicalSiteMention(jcas) : (conceptKey == 2 ? new DiseaseDisorderMention(jcas) : (conceptKey == 3 ? new SignSymptomMention(jcas) : (conceptKey == 9 ? new LabMention(jcas) : (conceptKey == 5 ? new ProcedureMention(jcas) : new EntityMention(jcas))))));
                    neAnnot.setTypeID(conceptKey);
                    neAnnot.setBegin(neBegin);
                    neAnnot.setEnd(neEnd);
                    neAnnot.setDiscoveryTechnique(1);
                    neAnnot.setOntologyConceptArr(conceptArr);
                    neAnnot.addToIndexes();
                }
            }
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    private int getNamedEntityType(String tui) throws IllegalArgumentException {
        if (this._medicationSet.contains(tui)) {
            return 1;
        }
        if (this._disorderTuiSet.contains(tui)) {
            return 2;
        }
        if (this._findingTuiSet.contains(tui)) {
            return 3;
        }
        if (this._antSiteTuiSet.contains(tui)) {
            return 6;
        }
        if (this._procedureTuiSet.contains(tui)) {
            return 5;
        }
        throw new IllegalArgumentException("TUI is not part of valid named entity types: " + tui);
    }

    private Collection<UmlsConcept> createConceptCol(JCas jcas, String cui, String tui, Collection<String> snomedCodesCol) {
        String codingSchemeKey = this.props.getProperty(CODING_SCHEME_PRP_KEY);
        ArrayList<UmlsConcept> conceptList = new ArrayList<UmlsConcept>();
        for (String snomedCode : snomedCodesCol) {
            UmlsConcept uc = new UmlsConcept(jcas);
            uc.setCode(snomedCode);
            uc.setCodingScheme(codingSchemeKey);
            uc.setCui(cui);
            uc.setTui(tui);
            conceptList.add(uc);
        }
        return conceptList;
    }

    private static String getUniqueKey(String cui, String tui) {
        StringBuilder sb = new StringBuilder();
        sb.append(cui);
        sb.append(':');
        sb.append(tui);
        return sb.toString();
    }

    private static Set<String> loadList(String delimitedString) {
        if (delimitedString == null || delimitedString.isEmpty()) {
            return Collections.emptySet();
        }
        String[] stringArray = delimitedString.split(",");
        HashSet<String> stringSet = new HashSet<String>();
        for (String text : stringArray) {
            String trimText = text.trim();
            if (trimText.isEmpty()) continue;
            stringSet.add(trimText);
        }
        return stringSet;
    }
}

