/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.annotation.HandlesTypes;
import org.eclipse.jetty.annotations.AbstractDiscoverableAnnotationHandler;
import org.eclipse.jetty.annotations.AnnotationDecorator;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.annotations.ClassInheritanceHandler;
import org.eclipse.jetty.annotations.ClassNameResolver;
import org.eclipse.jetty.annotations.ContainerInitializerAnnotationHandler;
import org.eclipse.jetty.annotations.ServletContainerInitializerListener;
import org.eclipse.jetty.annotations.WebFilterAnnotationHandler;
import org.eclipse.jetty.annotations.WebListenerAnnotationHandler;
import org.eclipse.jetty.annotations.WebServletAnnotationHandler;
import org.eclipse.jetty.plus.annotation.ContainerInitializer;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.FragmentDescriptor;
import org.eclipse.jetty.webapp.MetaDataComplete;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebDescriptor;

public class AnnotationConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(AnnotationConfiguration.class);
    public static final String CLASS_INHERITANCE_MAP = "org.eclipse.jetty.classInheritanceMap";
    public static final String CONTAINER_INITIALIZERS = "org.eclipse.jetty.containerInitializers";
    public static final String CONTAINER_INITIALIZER_LISTENER = "org.eclipse.jetty.containerInitializerListener";
    protected List<AnnotationParser.DiscoverableAnnotationHandler> _discoverableAnnotationHandlers = new ArrayList<AnnotationParser.DiscoverableAnnotationHandler>();
    protected ClassInheritanceHandler _classInheritanceHandler;
    protected List<ContainerInitializerAnnotationHandler> _containerInitializerAnnotationHandlers = new ArrayList<ContainerInitializerAnnotationHandler>();

    public void preConfigure(WebAppContext context) throws Exception {
    }

    public void addDiscoverableAnnotationHandler(AnnotationParser.DiscoverableAnnotationHandler handler) {
        this._discoverableAnnotationHandlers.add(handler);
    }

    public void deconfigure(WebAppContext context) throws Exception {
        context.removeAttribute(CLASS_INHERITANCE_MAP);
        context.removeAttribute(CONTAINER_INITIALIZERS);
        ServletContainerInitializerListener listener = (ServletContainerInitializerListener)((Object)context.getAttribute(CONTAINER_INITIALIZER_LISTENER));
        if (listener != null) {
            context.removeBean((Object)listener);
            context.removeAttribute(CONTAINER_INITIALIZER_LISTENER);
        }
    }

    public void configure(WebAppContext context) throws Exception {
        boolean metadataComplete = context.getMetaData().isMetaDataComplete();
        context.addDecorator((ServletContextHandler.Decorator)new AnnotationDecorator(context));
        AnnotationParser parser = null;
        if (!metadataComplete) {
            if (context.getServletContext().getEffectiveMajorVersion() >= 3 || context.isConfigurationDiscovered()) {
                this._discoverableAnnotationHandlers.add(new WebServletAnnotationHandler(context));
                this._discoverableAnnotationHandlers.add(new WebFilterAnnotationHandler(context));
                this._discoverableAnnotationHandlers.add(new WebListenerAnnotationHandler(context));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Metadata-complete==true,  not processing discoverable servlet annotations for context " + context, new Object[0]);
        }
        this.createServletContainerInitializerAnnotationHandlers(context, this.getNonExcludedInitializers(context));
        if (!this._discoverableAnnotationHandlers.isEmpty() || this._classInheritanceHandler != null || !this._containerInitializerAnnotationHandlers.isEmpty()) {
            parser = this.createAnnotationParser();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scanning all classses for annotations: webxmlVersion=" + context.getServletContext().getEffectiveMajorVersion() + " configurationDiscovered=" + context.isConfigurationDiscovered(), new Object[0]);
            }
            this.parseContainerPath(context, parser);
            this.parseWebInfClasses(context, parser);
            this.parseWebInfLib(context, parser);
            for (AnnotationParser.DiscoverableAnnotationHandler h : this._discoverableAnnotationHandlers) {
                context.getMetaData().addDiscoveredAnnotations(((AbstractDiscoverableAnnotationHandler)h).getAnnotationList());
            }
        }
    }

    public void postConfigure(WebAppContext context) throws Exception {
        MultiMap map = (MultiMap)context.getAttribute(CLASS_INHERITANCE_MAP);
        if (map != null) {
            map.clear();
        }
        context.removeAttribute(CLASS_INHERITANCE_MAP);
        List initializers = (List)context.getAttribute(CONTAINER_INITIALIZERS);
        if (initializers != null) {
            initializers.clear();
        }
        if (this._discoverableAnnotationHandlers != null) {
            this._discoverableAnnotationHandlers.clear();
        }
        this._classInheritanceHandler = null;
        if (this._containerInitializerAnnotationHandlers != null) {
            this._containerInitializerAnnotationHandlers.clear();
        }
        super.postConfigure(context);
    }

    protected AnnotationParser createAnnotationParser() {
        return new AnnotationParser();
    }

    public void cloneConfigure(WebAppContext template, WebAppContext context) throws Exception {
        context.addDecorator((ServletContextHandler.Decorator)new AnnotationDecorator(context));
    }

    public void createServletContainerInitializerAnnotationHandlers(WebAppContext context, List<ServletContainerInitializer> scis) throws Exception {
        if (scis == null || scis.isEmpty()) {
            return;
        }
        ArrayList<ContainerInitializer> initializers = new ArrayList<ContainerInitializer>();
        context.setAttribute(CONTAINER_INITIALIZERS, initializers);
        for (ServletContainerInitializer service : scis) {
            HandlesTypes annotation = service.getClass().getAnnotation(HandlesTypes.class);
            ContainerInitializer initializer = new ContainerInitializer();
            initializer.setTarget(service);
            initializers.add(initializer);
            if (annotation != null) {
                Class[] classes = annotation.value();
                if (classes != null) {
                    initializer.setInterestedTypes(classes);
                    if (context.getAttribute(CLASS_INHERITANCE_MAP) == null) {
                        MultiMap map = new MultiMap();
                        context.setAttribute(CLASS_INHERITANCE_MAP, (Object)map);
                        this._classInheritanceHandler = new ClassInheritanceHandler((MultiMap<String>)map);
                    }
                    for (Class c : classes) {
                        if (!c.isAnnotation()) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Registering annotation handler for " + c.getName(), new Object[0]);
                        }
                        this._containerInitializerAnnotationHandlers.add(new ContainerInitializerAnnotationHandler(initializer, c));
                    }
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("No classes in HandlesTypes on initializer " + service.getClass(), new Object[0]);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("No annotation on initializer " + service.getClass(), new Object[0]);
        }
        ServletContainerInitializerListener listener = (ServletContainerInitializerListener)((Object)context.getAttribute(CONTAINER_INITIALIZER_LISTENER));
        if (listener != null) {
            throw new IllegalStateException("ServletContainerInitializerListener already exists");
        }
        listener = new ServletContainerInitializerListener();
        listener.setWebAppContext(context);
        context.setAttribute(CONTAINER_INITIALIZER_LISTENER, (Object)listener);
        context.addBean((Object)listener, true);
    }

    public boolean isFromExcludedJar(WebAppContext context, ServletContainerInitializer service) throws Exception {
        List orderedJars = context.getMetaData().getOrderedWebInfJars();
        if (context.getMetaData().getOrdering() == null) {
            return false;
        }
        if (orderedJars.isEmpty()) {
            return true;
        }
        String loadingJarName = Thread.currentThread().getContextClassLoader().getResource(service.getClass().getName().replace('.', '/') + ".class").toString();
        int i = loadingJarName.indexOf(".jar");
        if (i < 0) {
            return false;
        }
        loadingJarName = (loadingJarName = loadingJarName.substring(0, i + 4)).startsWith("jar:") ? loadingJarName.substring(4) : loadingJarName;
        URI loadingJarURI = Resource.newResource((String)loadingJarName).getURI();
        boolean found = false;
        Iterator itor = orderedJars.iterator();
        while (!found && itor.hasNext()) {
            Resource r = (Resource)itor.next();
            found = r.getURI().equals(loadingJarURI);
        }
        return !found;
    }

    public List<ServletContainerInitializer> getNonExcludedInitializers(WebAppContext context) throws Exception {
        ArrayList<ServletContainerInitializer> nonExcludedInitializers = new ArrayList<ServletContainerInitializer>();
        ServiceLoader<ServletContainerInitializer> loadedInitializers = ServiceLoader.load(ServletContainerInitializer.class, context.getClassLoader());
        if (loadedInitializers != null) {
            for (ServletContainerInitializer service : loadedInitializers) {
                if (this.isFromExcludedJar(context, service)) continue;
                nonExcludedInitializers.add(service);
            }
        }
        return nonExcludedInitializers;
    }

    public void parseContainerPath(WebAppContext context, AnnotationParser parser) throws Exception {
        LOG.debug("Scanning container jars", new Object[0]);
        parser.clearHandlers();
        for (AnnotationParser.DiscoverableAnnotationHandler h : this._discoverableAnnotationHandlers) {
            if (!(h instanceof AbstractDiscoverableAnnotationHandler)) continue;
            ((AbstractDiscoverableAnnotationHandler)h).setResource(null);
        }
        parser.registerHandlers(this._discoverableAnnotationHandlers);
        parser.registerHandler(this._classInheritanceHandler);
        parser.registerHandlers(this._containerInitializerAnnotationHandlers);
        ArrayList<URI> containerUris = new ArrayList<URI>();
        for (Resource r : context.getMetaData().getContainerResources()) {
            URI uri = r.getURI();
            containerUris.add(uri);
        }
        parser.parse(containerUris.toArray(new URI[containerUris.size()]), (ClassNameResolver)new ContainerClassNameResolver(context));
    }

    public void parseWebInfLib(WebAppContext context, AnnotationParser parser) throws Exception {
        List frags = context.getMetaData().getFragments();
        ArrayList webInfUris = new ArrayList();
        List jars = context.getMetaData().getOrderedWebInfJars();
        if (jars == null || jars.isEmpty()) {
            jars = context.getMetaData().getWebInfJars();
        }
        for (Resource r : jars) {
            parser.clearHandlers();
            URI uri = r.getURI();
            FragmentDescriptor f = this.getFragmentFromJar(r, frags);
            if (f != null && this.isMetaDataComplete((WebDescriptor)f) && this._classInheritanceHandler == null && this._containerInitializerAnnotationHandlers.isEmpty()) continue;
            parser.registerHandler(this._classInheritanceHandler);
            parser.registerHandlers(this._containerInitializerAnnotationHandlers);
            if (f == null || !this.isMetaDataComplete((WebDescriptor)f)) {
                for (AnnotationParser.DiscoverableAnnotationHandler h : this._discoverableAnnotationHandlers) {
                    if (!(h instanceof AbstractDiscoverableAnnotationHandler)) continue;
                    ((AbstractDiscoverableAnnotationHandler)h).setResource(r);
                }
                parser.registerHandlers(this._discoverableAnnotationHandlers);
            }
            parser.parse(uri, (ClassNameResolver)new WebAppClassNameResolver(context));
        }
    }

    public void parseWebInfClasses(WebAppContext context, AnnotationParser parser) throws Exception {
        LOG.debug("Scanning classes in WEB-INF/classes", new Object[0]);
        parser.clearHandlers();
        for (AnnotationParser.DiscoverableAnnotationHandler h : this._discoverableAnnotationHandlers) {
            if (!(h instanceof AbstractDiscoverableAnnotationHandler)) continue;
            ((AbstractDiscoverableAnnotationHandler)h).setResource(null);
        }
        parser.registerHandlers(this._discoverableAnnotationHandlers);
        parser.registerHandler(this._classInheritanceHandler);
        parser.registerHandlers(this._containerInitializerAnnotationHandlers);
        for (Resource dir : context.getMetaData().getWebInfClassesDirs()) {
            parser.parseDir(dir, new WebAppClassNameResolver(context));
        }
    }

    public FragmentDescriptor getFragmentFromJar(Resource jar, List<FragmentDescriptor> frags) throws Exception {
        FragmentDescriptor d = null;
        for (FragmentDescriptor frag : frags) {
            Resource fragResource = frag.getResource();
            if (!Resource.isContainedIn((Resource)fragResource, (Resource)jar)) continue;
            d = frag;
            break;
        }
        return d;
    }

    public boolean isMetaDataComplete(WebDescriptor d) {
        return d != null && d.getMetaDataComplete() == MetaDataComplete.True;
    }

    public class ContainerClassNameResolver
    implements ClassNameResolver {
        private WebAppContext _context;

        public ContainerClassNameResolver(WebAppContext context) {
            this._context = context;
        }

        @Override
        public boolean isExcluded(String name) {
            if (this._context.isSystemClass(name)) {
                return false;
            }
            return this._context.isServerClass(name);
        }

        @Override
        public boolean shouldOverride(String name) {
            return this._context.isParentLoaderPriority();
        }
    }

    public class WebAppClassNameResolver
    implements ClassNameResolver {
        private WebAppContext _context;

        public WebAppClassNameResolver(WebAppContext context) {
            this._context = context;
        }

        @Override
        public boolean isExcluded(String name) {
            if (this._context.isSystemClass(name)) {
                return true;
            }
            if (this._context.isServerClass(name)) {
                return false;
            }
            return false;
        }

        @Override
        public boolean shouldOverride(String name) {
            return !this._context.isParentLoaderPriority();
        }
    }
}

