/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.svmlight;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cleartk.ml.CleartkProcessingException;
import org.cleartk.ml.Feature;
import org.cleartk.ml.encoder.features.FeaturesEncoder;
import org.cleartk.ml.encoder.outcome.OutcomeEncoder;
import org.cleartk.ml.sigmoid.Sigmoid;
import org.cleartk.ml.svmlight.SvmLightClassifier_ImplBase;
import org.cleartk.ml.svmlight.model.SvmLightModel;
import org.cleartk.ml.util.featurevector.FeatureVector;

public class SvmLightBooleanOutcomeClassifier
extends SvmLightClassifier_ImplBase<Boolean, Boolean> {
    protected Sigmoid sigmoid;

    public SvmLightBooleanOutcomeClassifier(FeaturesEncoder<FeatureVector> featuresEncoder, OutcomeEncoder<Boolean, Boolean> outcomeEncoder, SvmLightModel model, Sigmoid sigmoid) {
        super(featuresEncoder, outcomeEncoder, model);
        this.sigmoid = sigmoid;
    }

    @Override
    protected Boolean predictionToOutcome(double prediction) {
        return this.sigmoid.evaluate(prediction) > 0.5;
    }

    public Map<Boolean, Double> score(List<Feature> features) throws CleartkProcessingException {
        FeatureVector featureVector = (FeatureVector)this.featuresEncoder.encodeAll(features);
        double prediction = this.sigmoid.evaluate(this.model.evaluate(featureVector));
        HashMap scores = Maps.newHashMap();
        scores.put(true, prediction);
        scores.put(false, 1.0 - prediction);
        return scores;
    }
}

