/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.utils.kernel;

import libsvm.svm_node;
import org.apache.ctakes.utils.kernel.Kernel;

public class RBFKernel
extends Kernel {
    double gamma = 0.0;

    public RBFKernel(double gamma) {
        this.gamma = gamma;
    }

    @Override
    public double eval(Object o1, Object o2) {
        svm_node[] v1 = (svm_node[])o1;
        svm_node[] v2 = (svm_node[])o2;
        double squareNorm = 0.0;
        int i = 0;
        int j = 0;
        while (i < v1.length || j < v2.length) {
            if (i < v1.length && j < v2.length && v1[i].index == v2[j].index) {
                squareNorm += Math.pow(v1[i].value - v2[j].value, 2.0);
                ++i;
                ++j;
                continue;
            }
            if (i < v1.length && j == v2.length || i < v1.length && v1[i].index < v2[j].index) {
                squareNorm += Math.pow(v1[i].value, 2.0);
                ++i;
                continue;
            }
            squareNorm += Math.pow(v2[j].value, 2.0);
            ++j;
        }
        double sim = Math.exp(-this.gamma * squareNorm);
        return sim;
    }
}

