/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.utils.tree;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimpleTree {
    public String cat;
    public ArrayList<SimpleTree> children;
    public SimpleTree parent = null;
    static boolean generalizeLeaf = false;
    static Pattern ptPatt = Pattern.compile("\\(([^ (]+) +([^ )]+)\\)");

    public SimpleTree(String c) {
        this(c, null);
    }

    public SimpleTree(String c, SimpleTree p) {
        this.cat = SimpleTree.escapeCat(c);
        this.children = new ArrayList();
        this.parent = p;
    }

    public SimpleTree(String c, SimpleTree p, boolean g) {
        this.cat = SimpleTree.escapeCat(c);
        this.children = new ArrayList();
        this.parent = p;
        generalizeLeaf = g;
    }

    public static String escapeCat(String c) {
        c = c.replaceAll("\\(", "LPAREN");
        c = c.replaceAll("\\)", "RPAREN");
        return c;
    }

    public void addChild(SimpleTree t) {
        this.children.add(t);
    }

    public void insertChild(int index, SimpleTree t) {
        this.children.add(index, t);
    }

    public SimpleTree removeChild(int index) {
        return this.children.remove(index);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("(");
        buff.append(this.cat);
        buff.append(" ");
        if (this.children.size() == 1 && this.children.get((int)0).children.size() == 0) {
            if (generalizeLeaf) {
                buff.append("LEAF");
            } else {
                buff.append(this.children.get((int)0).cat);
            }
        } else {
            for (int i = 0; i < this.children.size(); ++i) {
                if (i != 0) {
                    buff.append(" ");
                }
                buff.append(this.children.get(i).toString());
            }
        }
        buff.append(")");
        return buff.toString();
    }

    public static SimpleTree fromString(String string) {
        SimpleTree tree = null;
        Matcher m = ptPatt.matcher(string);
        if (m.matches()) {
            tree = new SimpleTree(m.group(1));
            SimpleTree leaf = new SimpleTree(m.group(2));
            tree.addChild(leaf);
            leaf.parent = tree;
        } else {
            int firstWS = string.indexOf(32);
            tree = new SimpleTree(string.substring(1, firstWS));
            String[] childStrings = SimpleTree.splitChildren(string.substring(firstWS + 1, string.length() - 1));
            for (int i = 0; i < childStrings.length; ++i) {
                SimpleTree child = SimpleTree.fromString(childStrings[i]);
                child.parent = tree;
                tree.addChild(child);
            }
        }
        return tree;
    }

    private static String[] splitChildren(String s) {
        ArrayList<String> children = new ArrayList<String>();
        char[] chars = s.toCharArray();
        int numParens = 0;
        int startIndex = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '(') {
                if (++numParens != 1) continue;
                startIndex = i;
                continue;
            }
            if (chars[i] != ')') continue;
            if (--numParens == 0) {
                children.add(s.substring(startIndex, i + 1));
                continue;
            }
            if (numParens < 0) break;
        }
        return children.toArray(new String[0]);
    }

    public static void main(String[] args) {
        SimpleTree t = new SimpleTree("TOP");
        t.addChild(new SimpleTree("S"));
        t.children.get(0).addChild(new SimpleTree("NP"));
        t.children.get(0).addChild(new SimpleTree("VP"));
        t.children.get((int)0).children.get(0).addChild(new SimpleTree("i"));
        t.children.get((int)0).children.get(1).addChild(new SimpleTree("ran"));
        System.out.println(t.toString());
        SimpleTree t2 = SimpleTree.fromString("(S (NP (PRP it)) (VP (VBZ is) (JJ red)))");
        System.out.println(t2.toString());
    }

    public boolean isLeaf() {
        return this.children == null || this.children.size() == 0;
    }

    public void setGeneralizeLeaf(boolean b) {
        generalizeLeaf = b;
    }
}

