/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.component;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;

public final class FileTableCellEditor
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor,
ActionListener {
    private static final Logger LOGGER = Logger.getLogger((String)"FileTableCellEditor");
    private final JButton _button;
    private final JFileChooser _chooser;
    private File _selectedFile;

    public FileTableCellEditor() {
        Icon icon = UIManager.getIcon("FileView.directoryIcon");
        this._button = new JButton(icon);
        this._button.setFocusPainted(false);
        this._button.setFocusable(false);
        this._button.setToolTipText("Select File");
        this._button.addActionListener(this);
        this._chooser = new JFileChooser();
    }

    public JFileChooser getFileChooser() {
        return this._chooser;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this._button;
    }

    @Override
    public Object getCellEditorValue() {
        return this._selectedFile;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (File.class.isInstance(value)) {
            this._selectedFile = (File)value;
        }
        return this._button;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        int option = this._chooser.showOpenDialog(null);
        if (option != 0) {
            return;
        }
        this._selectedFile = this._chooser.getSelectedFile();
        this.fireEditingStopped();
    }
}

