/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.pipeline.bit.info;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.gui.component.CellRendererLabel;
import org.apache.ctakes.gui.util.IconLoader;
import org.apache.log4j.Logger;

public final class RoleRenderer
implements ListCellRenderer<Object> {
    private static final Logger LOGGER = Logger.getLogger((String)"RoleRenderer");
    private static final String READER_ICON_FILE = "GreenArrowIn.png";
    private static final String ANNOTATOR_ICON_FILE = "BlueGear.png";
    private static final String WRITER_ICON_FILE = "BlueArrowOut.png";
    private static final String SPECIAL_ICON_FILE = "Utilities.png";
    private final JLabel _reader = new CellRendererLabel();
    private final JLabel _annotator = new CellRendererLabel();
    private final JLabel _writer = new CellRendererLabel();
    private final JLabel _special = new CellRendererLabel();

    public RoleRenderer() {
        RoleRenderer.decorate(this._reader);
        RoleRenderer.decorate(this._annotator);
        RoleRenderer.decorate(this._writer);
        RoleRenderer.decorate(this._special);
        SwingUtilities.invokeLater(new RoleIconLoader());
    }

    private static void decorate(JLabel renderer) {
        Color background = UIManager.getColor("List.background");
        renderer.setBackground(background);
        renderer.setBorder(new EmptyBorder(0, 2, 0, 2));
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (!PipeBitInfo.class.isInstance(value)) {
            LOGGER.error((Object)(value.getClass().getName() + " is not a PipeBitInfo"));
            JLabel renderer = new JLabel("Invalid");
            renderer.setBackground(Color.DARK_GRAY);
            renderer.setToolTipText("Invalid Information");
            return renderer;
        }
        PipeBitInfo info = (PipeBitInfo)value;
        switch (info.role()) {
            case READER: {
                return this._reader;
            }
            case ANNOTATOR: {
                return this._annotator;
            }
            case WRITER: {
                return this._writer;
            }
            case SPECIAL: {
                return this._special;
            }
        }
        return new JLabel();
    }

    private final class RoleIconLoader
    implements Runnable {
        private static final int ICON_SIZE = 16;
        private static final String ICON_DIR = "org/apache/ctakes/gui/pipeline/icon/";

        private RoleIconLoader() {
        }

        @Override
        public void run() {
            Icon reader = IconLoader.loadIcon("org/apache/ctakes/gui/pipeline/icon/GreenArrowIn.png", 16);
            RoleRenderer.this._reader.setIcon(reader);
            Icon annotator = IconLoader.loadIcon("org/apache/ctakes/gui/pipeline/icon/BlueGear.png", 16);
            RoleRenderer.this._annotator.setIcon(annotator);
            Icon writer = IconLoader.loadIcon("org/apache/ctakes/gui/pipeline/icon/BlueArrowOut.png", 16);
            RoleRenderer.this._writer.setIcon(writer);
            Icon special = IconLoader.loadIcon("org/apache/ctakes/gui/pipeline/icon/Utilities.png", 16);
            RoleRenderer.this._special.setIcon(special);
        }
    }
}

