/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Lib;

import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Inflection;

public class CatInfl {
    private long cat_ = 0L;
    private long infl_ = 0L;
    private static final boolean[][] CAT_INFL_RELATION = new boolean[11][24];

    public CatInfl(long cat, long infl) {
        this.cat_ = cat;
        this.infl_ = infl;
    }

    public long GetCategory() {
        return this.cat_;
    }

    public long GetInflection() {
        return this.infl_;
    }

    public String GetCategoryStr() {
        String categoryStr = Category.ToName(this.cat_);
        return categoryStr;
    }

    public String GetInflectionStr() {
        String inflectionStr = Inflection.ToName(this.infl_);
        return inflectionStr;
    }

    public static CatInfl ConvertToBase(CatInfl in) {
        long cat = in.GetCategory();
        long infl = in.GetInflection();
        if (infl == Inflection.ToValue("singular") && cat == Category.ToValue("noun")) {
            infl = Inflection.ToValue("base");
        } else if (infl == Inflection.ToValue("infinitive") && cat == Category.ToValue("verb")) {
            infl = Inflection.ToValue("base");
        } else if (infl == Inflection.ToValue("positive") && cat == Category.ToValue("adj")) {
            infl = Inflection.ToValue("base");
        } else if (infl == Inflection.ToValue("positive") && cat == Category.ToValue("adv")) {
            infl = Inflection.ToValue("base");
        }
        return new CatInfl(cat, infl);
    }

    public static boolean IsRelated(long cat, long infl) {
        int catIndex = Category.GetBitIndex(cat);
        int inflIndex = Inflection.GetBitIndex(infl);
        return CAT_INFL_RELATION[catIndex][inflIndex];
    }

    static {
        for (int i = 0; i < 11; ++i) {
            CatInfl.CAT_INFL_RELATION[i][0] = true;
            for (int j = 1; j < 24; ++j) {
                CatInfl.CAT_INFL_RELATION[i][j] = false;
            }
        }
        CatInfl.CAT_INFL_RELATION[0][1] = true;
        CatInfl.CAT_INFL_RELATION[0][2] = true;
        CatInfl.CAT_INFL_RELATION[0][8] = true;
        CatInfl.CAT_INFL_RELATION[1][1] = true;
        CatInfl.CAT_INFL_RELATION[1][2] = true;
        CatInfl.CAT_INFL_RELATION[1][8] = true;
        CatInfl.CAT_INFL_RELATION[2][4] = true;
        CatInfl.CAT_INFL_RELATION[2][5] = true;
        CatInfl.CAT_INFL_RELATION[2][6] = true;
        CatInfl.CAT_INFL_RELATION[2][7] = true;
        CatInfl.CAT_INFL_RELATION[2][10] = true;
        CatInfl.CAT_INFL_RELATION[2][11] = true;
        CatInfl.CAT_INFL_RELATION[2][12] = true;
        CatInfl.CAT_INFL_RELATION[2][13] = true;
        CatInfl.CAT_INFL_RELATION[2][14] = true;
        CatInfl.CAT_INFL_RELATION[2][15] = true;
        CatInfl.CAT_INFL_RELATION[2][16] = true;
        CatInfl.CAT_INFL_RELATION[2][17] = true;
        CatInfl.CAT_INFL_RELATION[2][18] = true;
        CatInfl.CAT_INFL_RELATION[2][19] = true;
        CatInfl.CAT_INFL_RELATION[2][20] = true;
        CatInfl.CAT_INFL_RELATION[2][22] = true;
        CatInfl.CAT_INFL_RELATION[6][5] = true;
        CatInfl.CAT_INFL_RELATION[6][12] = true;
        CatInfl.CAT_INFL_RELATION[6][21] = true;
        CatInfl.CAT_INFL_RELATION[6][23] = true;
        CatInfl.CAT_INFL_RELATION[7][3] = true;
        CatInfl.CAT_INFL_RELATION[7][9] = true;
        CatInfl.CAT_INFL_RELATION[10][4] = true;
        CatInfl.CAT_INFL_RELATION[10][5] = true;
        CatInfl.CAT_INFL_RELATION[10][6] = true;
        CatInfl.CAT_INFL_RELATION[10][7] = true;
        CatInfl.CAT_INFL_RELATION[10][10] = true;
        CatInfl.CAT_INFL_RELATION[10][11] = true;
    }
}

