/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Trie;

import gov.nih.nlm.nls.lvg.Trie.PersistentRuleNode;
import gov.nih.nlm.nls.lvg.Trie.PersistentTreeNode;
import java.io.IOException;
import java.io.RandomAccessFile;

public class PersistentTrieNode
extends PersistentTreeNode {
    private char key_ = (char)32;
    private long ruleAddress_ = -1L;

    public PersistentTrieNode(long address) {
        super(address);
    }

    public PersistentTrieNode(char key, long ruleAddress) {
        this.key_ = key;
        this.ruleAddress_ = ruleAddress;
    }

    public PersistentTrieNode(int level, long parent, long next, long child, long address) {
        super(level, parent, next, child, address);
    }

    public char GetKey() {
        return this.key_;
    }

    public long GetRuleAddress() {
        return this.ruleAddress_;
    }

    @Override
    public void WriteData(RandomAccessFile raf) throws IOException {
        raf.writeChar(this.key_);
        raf.writeLong(this.ruleAddress_);
    }

    @Override
    public void ReadData(RandomAccessFile raf) throws IOException {
        this.key_ = raf.readChar();
        this.ruleAddress_ = raf.readLong();
    }

    public static PersistentTreeNode GetNode(RandomAccessFile raf, long address) throws IOException {
        PersistentTrieNode node = new PersistentTrieNode(address);
        raf.seek(address);
        int level = raf.readInt();
        long next = raf.readLong();
        long parent = raf.readLong();
        long child = raf.readLong();
        node.ReadData(raf);
        node.SetLevel(level);
        node.SetParent(parent);
        node.SetNext(next);
        node.SetChild(child);
        return node;
    }

    public static int PrintNode(RandomAccessFile trieRaf, long address, String rulePath, String exceptionPath) throws IOException {
        int nodeNum = 0;
        PersistentTrieNode trieNode = (PersistentTrieNode)PersistentTrieNode.GetNode(trieRaf, address);
        System.out.print("--");
        for (int i = 0; i < trieNode.GetLevel(); ++i) {
            System.out.print("---");
        }
        long ruleAddress = trieNode.GetRuleAddress();
        System.out.print(" (" + trieNode.GetKey() + "@ " + address + ", Rule @: " + ruleAddress + ")");
        System.out.print(System.getProperty("line.separator").toString());
        ++nodeNum;
        if (ruleAddress != -1L) {
            PersistentRuleNode.PrintList(rulePath, exceptionPath, ruleAddress);
        }
        long childAddress = trieNode.GetChild();
        while (childAddress != -1L) {
            PersistentTreeNode childNode = PersistentTrieNode.GetNode(trieRaf, childAddress);
            nodeNum += PersistentTrieNode.PrintNode(trieRaf, childAddress, rulePath, exceptionPath);
            childAddress = childNode.GetNext();
        }
        return nodeNum;
    }
}

