/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Trie;

import java.util.StringTokenizer;

public class RuleException {
    private String exceptionStr_ = null;
    private String key_ = null;
    private String value_ = null;
    private boolean legalFormat_ = true;

    public RuleException(String exceptionStr) {
        this.exceptionStr_ = exceptionStr.trim();
        this.DecomposeExceptionStr();
    }

    public void Reverse() {
        String tempKey = this.key_;
        this.key_ = this.value_;
        this.value_ = tempKey;
        this.exceptionStr_ = this.key_ + "|" + this.value_ + ";";
    }

    public boolean equals(RuleException exception) {
        return this.exceptionStr_.equals(exception.GetExceptionStr());
    }

    public String GetKey() {
        return this.key_;
    }

    public String GetValue() {
        return this.value_;
    }

    public String GetExceptionStr() {
        return this.exceptionStr_;
    }

    public boolean IsLegalFormat() {
        return this.legalFormat_;
    }

    public static void main(String[] args) {
        String exStr = "  key|value";
        RuleException ex = new RuleException(exStr);
        ex.PrintException();
        ex.Reverse();
        ex.PrintException();
        exStr = "|value;";
        ex = new RuleException(exStr);
        ex.PrintException();
        ex.Reverse();
        ex.PrintException();
        exStr = "key|;";
        ex = new RuleException(exStr);
        ex.PrintException();
        ex.Reverse();
        ex.PrintException();
        exStr = "|;";
        ex = new RuleException(exStr);
        ex.PrintException();
        ex.Reverse();
        ex.PrintException();
    }

    private void DecomposeExceptionStr() {
        if (this.exceptionStr_ == null || this.exceptionStr_.indexOf(124) == -1 || !this.exceptionStr_.endsWith(";")) {
            System.err.println("** Err@RuleException.DecomposeExceptionStr( ): Wrong format in RuleException(" + this.exceptionStr_ + ")");
            this.legalFormat_ = false;
            return;
        }
        StringTokenizer buf = new StringTokenizer(this.exceptionStr_, "|;");
        if (this.exceptionStr_.equals("|;")) {
            this.key_ = "";
            this.value_ = "";
        } else if (this.exceptionStr_.startsWith("|")) {
            this.key_ = "";
            this.value_ = buf.nextToken();
        } else if (this.exceptionStr_.endsWith("|;")) {
            this.key_ = buf.nextToken();
            this.value_ = "";
        } else {
            this.key_ = buf.nextToken();
            this.value_ = buf.nextToken();
        }
    }

    private void PrintException() {
        System.out.println("------ Rule Exception ------");
        System.out.println("exceptionStr_: " + this.exceptionStr_);
        System.out.println("key_: " + this.key_);
        System.out.println("value_: " + this.value_);
    }
}

