/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.web.search;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.ctakes.ytex.web.search.ConceptFirstWord;
import org.apache.ctakes.ytex.web.search.ConceptSearchService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class ConceptSearchServiceImpl
implements ConceptSearchService,
InitializingBean {
    private String conceptIdToTermQuery;
    private Pattern conceptPattern;
    private DataSource dataSource;
    private String fwordToConceptIdQuery;
    private SimpleJdbcTemplate jdbcTemplate;
    private Properties searchProperties;
    private Properties ytexProperties;

    public void afterPropertiesSet() throws Exception {
        this.fwordToConceptIdQuery = this.prepareQuery(this.getSearchProperties().getProperty("retrieveConceptByFword"));
        this.conceptIdToTermQuery = this.prepareQuery(this.getSearchProperties().getProperty("retrieveTermByConceptId"));
        this.conceptPattern = Pattern.compile(this.searchProperties.getProperty("conceptIdPattern", "\\AC\\d{7}\\Z"));
    }

    @Override
    public List<ConceptFirstWord> getConceptByFirstWord(String textStart) {
        String[] words = textStart.toLowerCase().split("\\s+");
        String fword = textStart.toLowerCase();
        String text = textStart.toLowerCase();
        int nTextLength = textStart.length();
        if (words.length > 1) {
            fword = words[0];
        }
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("fword", fword);
        args.put("fwordlen", fword.length());
        args.put("term", text);
        args.put("termlen", nTextLength);
        return this.jdbcTemplate.query(this.fwordToConceptIdQuery, (RowMapper)new ConceptFirstWordRowMapper(), args);
    }

    private List<ConceptFirstWord> getConceptById(String conceptId) {
        String term = this.getTermByConceptId(conceptId);
        if (term != null) {
            ArrayList<ConceptFirstWord> terms = new ArrayList<ConceptFirstWord>(1);
            ConceptFirstWord cft = new ConceptFirstWord();
            cft.setConceptId(conceptId);
            cft.setFword(term);
            cft.setText(term);
            terms.add(cft);
            return terms;
        }
        return new ArrayList<ConceptFirstWord>(0);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public Properties getSearchProperties() {
        return this.searchProperties;
    }

    @Override
    public String checkTermByConceptId(String conceptId) {
        Matcher m = this.conceptPattern.matcher(conceptId);
        if (m.find()) {
            return this.getTermByConceptId(conceptId);
        }
        return null;
    }

    @Override
    public String getTermByConceptId(String conceptId) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("conceptId", conceptId);
        return (String)this.jdbcTemplate.queryForObject(this.conceptIdToTermQuery, String.class, args);
    }

    public Properties getYtexProperties() {
        return this.ytexProperties;
    }

    private String prepareQuery(String queryTemplate) {
        String dbName = this.getYtexProperties().getProperty("db.name");
        String dbSchema = this.getYtexProperties().getProperty("db.schema");
        String umlsSchema = this.getYtexProperties().getProperty("umls.schema", dbSchema);
        String umlsCatalog = this.getYtexProperties().getProperty("umls.catalog", dbName);
        String query = queryTemplate.replaceAll("@db\\.schema@", this.getYtexProperties().getProperty("db.schema"));
        query = query.replaceAll("@umls\\.schema@", umlsSchema);
        query = query.replaceAll("@umls\\.catalog@", umlsCatalog);
        return query;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    public void setSearchProperties(Properties searchProperties) {
        this.searchProperties = searchProperties;
    }

    public void setYtexProperties(Properties ytexProperties) {
        this.ytexProperties = ytexProperties;
    }

    public static class ConceptFirstWordRowMapper
    implements RowMapper<ConceptFirstWord> {
        public ConceptFirstWord mapRow(ResultSet rs, int rowNum) throws SQLException {
            ConceptFirstWord fword = new ConceptFirstWord();
            fword.setConceptId(rs.getString("conceptId"));
            fword.setFword(rs.getString("fword"));
            fword.setText(rs.getString("text"));
            return fword;
        }
    }
}

