/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.dbms.h2;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDDLGenerator;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.dbms.DBMSFeature;
import org.apache.empire.dbms.DBMSHandlerBase;
import org.apache.empire.dbms.DBSqlPhrase;
import org.apache.empire.dbms.h2.H2DDLGenerator;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.NotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBMSHandlerH2
extends DBMSHandlerBase {
    private static final Logger log = LoggerFactory.getLogger(DBMSHandlerH2.class);
    private String databaseName = null;
    private boolean useSequenceTable = false;
    private String sequenceTableName = "Sequences";
    private DBDDLGenerator<?> ddlGenerator = null;

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public boolean isUseSequenceTable() {
        return this.useSequenceTable;
    }

    public void setUseSequenceTable(boolean useSequenceTable) {
        this.useSequenceTable = useSequenceTable;
    }

    public String getSequenceTableName() {
        return this.sequenceTableName;
    }

    public void setSequenceTableName(String sequenceTableName) {
        this.sequenceTableName = sequenceTableName;
    }

    @Override
    public DBCommand createCommand(boolean autoPrepareStmt) {
        return new DBCommandH2(this, autoPrepareStmt);
    }

    @Override
    public boolean isSupported(DBMSFeature type) {
        switch (type) {
            case CREATE_SCHEMA: {
                return true;
            }
            case SEQUENCES: {
                return this.useSequenceTable;
            }
            case QUERY_LIMIT_ROWS: {
                return true;
            }
            case QUERY_SKIP_ROWS: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getSQLPhrase(DBSqlPhrase phrase) {
        switch (phrase) {
            case SQL_NULL: {
                return "null";
            }
            case SQL_PARAMETER: {
                return " ? ";
            }
            case SQL_RENAME_TABLE: {
                return " ";
            }
            case SQL_RENAME_COLUMN: {
                return " AS ";
            }
            case SQL_DATABASE_LINK: {
                return "@";
            }
            case SQL_QUOTES_OPEN: {
                return "\"";
            }
            case SQL_QUOTES_CLOSE: {
                return "\"";
            }
            case SQL_CONCAT_EXPR: {
                return "concat(?, {0})";
            }
            case SQL_BOOLEAN_TRUE: {
                return "1";
            }
            case SQL_BOOLEAN_FALSE: {
                return "0";
            }
            case SQL_CURRENT_DATE: {
                return "CURRENT_DATE";
            }
            case SQL_DATE_TEMPLATE: {
                return "'{0}'";
            }
            case SQL_CURRENT_TIME: {
                return "CURRENT_TIME";
            }
            case SQL_TIME_TEMPLATE: {
                return "'{0}'";
            }
            case SQL_CURRENT_DATETIME: {
                return "NOW()";
            }
            case SQL_DATETIME_TEMPLATE: {
                return "'{0}'";
            }
            case SQL_CURRENT_TIMESTAMP: {
                return "NOW()";
            }
            case SQL_TIMESTAMP_TEMPLATE: {
                return "'{0}'";
            }
            case SQL_FUNC_COALESCE: {
                return "coalesce(?, {0})";
            }
            case SQL_FUNC_SUBSTRING: {
                return "substring(?, {0})";
            }
            case SQL_FUNC_SUBSTRINGEX: {
                return "substring(?, {0}, {1})";
            }
            case SQL_FUNC_REPLACE: {
                return "replace(?, {0}, {1})";
            }
            case SQL_FUNC_REVERSE: {
                return "reverse_not_available_in_h2(?)";
            }
            case SQL_FUNC_STRINDEX: {
                return "instr(?, {0})";
            }
            case SQL_FUNC_STRINDEXFROM: {
                return "locate({0}, ?, {1})";
            }
            case SQL_FUNC_LENGTH: {
                return "length(?)";
            }
            case SQL_FUNC_UPPER: {
                return "upper(?)";
            }
            case SQL_FUNC_LOWER: {
                return "lcase(?)";
            }
            case SQL_FUNC_TRIM: {
                return "trim(?)";
            }
            case SQL_FUNC_LTRIM: {
                return "ltrim(?)";
            }
            case SQL_FUNC_RTRIM: {
                return "rtrim(?)";
            }
            case SQL_FUNC_ESCAPE: {
                return "? escape {0:VARCHAR}";
            }
            case SQL_FUNC_ABS: {
                return "abs(?)";
            }
            case SQL_FUNC_ROUND: {
                return "round(?,{0})";
            }
            case SQL_FUNC_TRUNC: {
                return "truncate(?,{0})";
            }
            case SQL_FUNC_CEILING: {
                return "ceiling(?)";
            }
            case SQL_FUNC_FLOOR: {
                return "floor(?)";
            }
            case SQL_FUNC_MOD: {
                return "mod(?,{0})";
            }
            case SQL_FUNC_FORMAT: {
                return "format(?, {0:VARCHAR})";
            }
            case SQL_FUNC_DAY: {
                return "day(?)";
            }
            case SQL_FUNC_MONTH: {
                return "month(?)";
            }
            case SQL_FUNC_YEAR: {
                return "year(?)";
            }
            case SQL_FUNC_SUM: {
                return "sum(?)";
            }
            case SQL_FUNC_MAX: {
                return "max(?)";
            }
            case SQL_FUNC_MIN: {
                return "min(?)";
            }
            case SQL_FUNC_AVG: {
                return "avg(?)";
            }
            case SQL_FUNC_DECODE: {
                return "case ? {0} end";
            }
            case SQL_FUNC_DECODE_SEP: {
                return " ";
            }
            case SQL_FUNC_DECODE_PART: {
                return "when {0} then {1}";
            }
            case SQL_FUNC_DECODE_ELSE: {
                return "else {0}";
            }
        }
        return phrase.getSqlDefault();
    }

    @Override
    public String getConvertPhrase(DataType destType, DataType srcType, Object format) {
        switch (destType) {
            case BOOL: {
                return "CAST(? AS UNSIGNED)";
            }
            case INTEGER: {
                return "CAST(? AS SIGNED)";
            }
            case DECIMAL: {
                return "CAST(? AS DECIMAL)";
            }
            case FLOAT: {
                return "CAST(? AS DECIMAL)";
            }
            case DATE: {
                return "CAST(? AS DATE)";
            }
            case TIME: {
                return "CAST(? AS TIME)";
            }
            case DATETIME: 
            case TIMESTAMP: {
                return "CAST(? AS DATETIME)";
            }
            case VARCHAR: 
            case CHAR: {
                return "CAST(? AS CHAR)";
            }
            case BLOB: {
                return "CAST(? AS BLOB)";
            }
        }
        log.error("getConvertPhrase: unknown type " + (Object)((Object)destType));
        return "?";
    }

    @Override
    public Object getNextSequenceValue(DBDatabase db, String seqName, int minValue, Connection conn) {
        if (this.useSequenceTable) {
            DBTable t = db.getTable(this.sequenceTableName);
            return ((DBMSHandlerBase.DBSeqTable)t).getNextValue(seqName, minValue, conn);
        }
        return null;
    }

    @Override
    public DBColumnExpr getNextSequenceValueExpr(DBTableColumn column) {
        throw new NotSupportedException(this, "getNextSequenceValueExpr");
    }

    @Override
    public Timestamp getUpdateTimestamp(Connection conn) {
        GregorianCalendar cal = new GregorianCalendar();
        return new Timestamp(cal.getTimeInMillis());
    }

    @Override
    public void getDDLScript(DBDDLGenerator.DDLActionType type, DBObject dbo, DBSQLScript script) {
        if (this.ddlGenerator == null) {
            this.ddlGenerator = new H2DDLGenerator(this);
        }
        this.ddlGenerator.getDDLScript(type, dbo, script);
    }

    public static class DBCommandH2
    extends DBCommand {
        protected int limitRows = -1;
        protected int skipRows = 0;

        public DBCommandH2(DBMSHandlerH2 dbms, boolean autoPrepareStmt) {
            super(dbms, autoPrepareStmt);
        }

        @Override
        public DBCommand limitRows(int limitRows) {
            this.limitRows = limitRows;
            return this;
        }

        @Override
        public DBCommand skipRows(int skipRows) {
            if (skipRows < 0) {
                throw new InvalidArgumentException("skipRows", skipRows);
            }
            this.skipRows = skipRows;
            return this;
        }

        @Override
        public void clearLimit() {
            this.limitRows = -1;
            this.skipRows = 0;
        }

        @Override
        public void getSelect(DBSQLBuilder sql, int flags) {
            super.getSelect(sql, flags);
            if (this.limitRows >= 0 && this.not(flags, 32)) {
                sql.append("\r\nLIMIT ");
                sql.append(String.valueOf(this.limitRows));
                if (this.skipRows > 0) {
                    sql.append(" OFFSET ");
                    sql.append(String.valueOf(this.skipRows));
                }
            }
        }
    }
}

