/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.agentdir;

import com.navercorp.pinpoint.bootstrap.BootLogger;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

final class FileUtils {
    private static final BootLogger logger = BootLogger.getLogger(FileUtils.class);

    private FileUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Path> listFiles(Path dirPath, String glob) {
        Objects.requireNonNull(dirPath, "dirPath");
        Objects.requireNonNull(glob, "glob");
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(dirPath, glob);){
            ArrayList<Path> list = new ArrayList<Path>();
            for (Path path : paths) {
                list.add(path);
            }
            ArrayList<Path> arrayList = list;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException(dirPath + " Path IO error", e);
        }
    }

    public static Path toRealPath(Path path) {
        try {
            return path.toRealPath(new LinkOption[0]).normalize();
        }
        catch (IOException e) {
            logger.warn(path + " toRealPath() error. Error:" + e.getMessage(), e);
            return path.toAbsolutePath();
        }
    }
}

