/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.io;

import io.pravega.common.io.serialization.RandomAccessOutputStream;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.ByteArraySegment;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ByteBufferOutputStream
extends OutputStream
implements RandomAccessOutputStream {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private ByteBuffer buf;

    public ByteBufferOutputStream() {
        this(128);
    }

    public ByteBufferOutputStream(int initialSize) {
        this.buf = ByteBuffer.allocate(initialSize);
    }

    @Override
    public void write(int b) {
        this.ensureExtraCapacity(1);
        this.buf.put((byte)b);
    }

    @Override
    public void write(int byteValue, int streamPosition) {
        this.buf.put(streamPosition, (byte)byteValue);
    }

    @Override
    public void write(byte[] array) {
        this.write(array, 0, array.length);
    }

    @Override
    public void write(byte[] b, int offset, int length) {
        this.ensureExtraCapacity(length);
        this.buf.put(b, offset, length);
    }

    @Override
    public void write(byte[] array, int arrayOffset, int length, int streamPosition) {
        if (arrayOffset < 0 || length < 0 || length > 0 && arrayOffset + length > array.length) {
            throw new ArrayIndexOutOfBoundsException("bufferOffset and length must refer to a range within buffer.");
        }
        int extra = streamPosition + length - this.buf.position();
        if (extra > 0) {
            this.ensureExtraCapacity(extra);
        }
        int originalPos = this.buf.position();
        this.buf.position(streamPosition);
        this.buf.put(array, arrayOffset, length);
        this.buf.position(Math.max(originalPos, streamPosition + length));
    }

    @Override
    public int size() {
        return this.buf.position();
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    @Override
    public void writeBuffer(BufferView buffer) {
        this.ensureExtraCapacity(buffer.getLength());
        int bytesCopied = buffer.copyTo(this.buf);
        assert (bytesCopied == buffer.getLength());
    }

    @Override
    public void writeShort(int shortValue) {
        this.ensureExtraCapacity(2);
        this.buf.putShort((short)shortValue);
    }

    @Override
    public void writeInt(int intValue) {
        this.ensureExtraCapacity(4);
        this.buf.putInt(intValue);
    }

    @Override
    public void writeInt(int intValue, int streamPosition) {
        this.buf.putInt(streamPosition, intValue);
    }

    @Override
    public void writeLong(long longValue) {
        this.ensureExtraCapacity(8);
        this.buf.putLong(longValue);
    }

    @Override
    public ByteArraySegment getData() {
        return new ByteArraySegment(this.buf.array(), this.buf.arrayOffset(), this.size());
    }

    private void ensureExtraCapacity(int count) {
        int minCapacity = this.buf.position() + count;
        if (minCapacity <= this.buf.limit()) {
            return;
        }
        int oldCapacity = this.buf.limit();
        int newCapacity = oldCapacity << 1;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            if (minCapacity < 0) {
                throw new OutOfMemoryError();
            }
            newCapacity = minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
        }
        int oldPosition = this.buf.position();
        this.buf.position(0);
        ByteBuffer newBuf = ByteBuffer.allocate(newCapacity);
        newBuf.put(this.buf);
        newBuf.position(oldPosition);
        this.buf = newBuf;
    }
}

