/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.instrument.matcher;

import com.navercorp.pinpoint.bootstrap.instrument.matcher.DefaultClassBasedMatcher;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.DefaultClassNameMatcher;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.DefaultMultiClassBasedMatcher;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.DefaultMultiClassNameMatcher;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.DefaultMultiPackageBasedMatcher;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.DefaultPackageBasedMatcher;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.Matcher;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operand.MatcherOperand;
import com.navercorp.pinpoint.common.annotations.InterfaceStability;
import java.util.List;

@InterfaceStability.Unstable
public final class Matchers {
    private Matchers() {
    }

    public static Matcher newClassNameMatcher(String classInternalName) {
        return new DefaultClassNameMatcher(classInternalName);
    }

    public static Matcher newMultiClassNameMatcher(List<String> classNameList) {
        return new DefaultMultiClassNameMatcher(classNameList);
    }

    public static Matcher newPackageBasedMatcher(String basePackageName) {
        return new DefaultPackageBasedMatcher(basePackageName);
    }

    public static Matcher newPackageBasedMatcher(String basePackageName, MatcherOperand additional) {
        return new DefaultPackageBasedMatcher(basePackageName, additional);
    }

    public static Matcher newPackageBasedMatcher(List<String> basePackageNames) {
        return new DefaultMultiPackageBasedMatcher(basePackageNames);
    }

    public static Matcher newPackageBasedMatcher(List<String> basePackageNames, MatcherOperand additional) {
        return new DefaultMultiPackageBasedMatcher(basePackageNames, additional);
    }

    public static Matcher newClassBasedMatcher(String baseClassName) {
        return new DefaultClassBasedMatcher(baseClassName);
    }

    public static Matcher newClassBasedMatcher(String baseClassName, MatcherOperand additional) {
        return new DefaultClassBasedMatcher(baseClassName, additional);
    }

    public static Matcher newMultiClassBasedMatcher(List<String> baseClassNames) {
        return new DefaultMultiClassBasedMatcher(baseClassNames);
    }

    public static Matcher newMultiClassBasedMatcher(List<String> baseClassNames, MatcherOperand additional) {
        return new DefaultMultiClassBasedMatcher(baseClassNames, additional);
    }
}

