/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.instrument.transformer;

import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.ArrayUtils;

public final class ParameterUtils {
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Class<?>[] SUPPORT_CLASS = new Class[]{ServiceType.class, String.class, Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class};

    private ParameterUtils() {
    }

    public static boolean hasNull(Object[] parameters) {
        if (ArrayUtils.isEmpty((Object[])parameters)) {
            return false;
        }
        for (Object parameter : parameters) {
            if (parameter != null) continue;
            return true;
        }
        return false;
    }

    public static Class<?>[] toClass(Object[] parameters) {
        if (parameters == null) {
            return null;
        }
        if (parameters.length == 0) {
            return EMPTY_CLASS_ARRAY;
        }
        Class[] parameterTypeArray = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Class<?> type;
            Object argument = parameters[i];
            parameterTypeArray[i] = type = argument == null ? null : argument.getClass();
        }
        return parameterTypeArray;
    }

    public static void checkParameterType(Class[] classes) {
        if (ArrayUtils.isEmpty((Object[])classes)) {
            return;
        }
        for (Class clazz : classes) {
            if (clazz == null) continue;
            if (clazz.getClassLoader() != Object.class.getClassLoader()) {
                throw new IllegalArgumentException("unsupported classloader " + clazz);
            }
            Class<?> clazz2 = ParameterUtils.getRawComponentType(clazz);
            if (clazz2.isPrimitive()) {
                return;
            }
            boolean supportedClass = false;
            for (Class<?> supportClass : SUPPORT_CLASS) {
                if (!supportClass.isAssignableFrom(clazz2)) continue;
                supportedClass = true;
                break;
            }
            if (supportedClass) continue;
            throw new IllegalArgumentException("unsupported type:" + clazz2);
        }
    }

    static Class<?> getRawComponentType(Class<?> aClass) {
        while (aClass.isArray()) {
            aClass = aClass.getComponentType();
        }
        return aClass;
    }
}

