/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.thrift;

import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.profiler.context.SpanType;
import com.navercorp.pinpoint.profiler.context.compress.SpanProcessor;
import com.navercorp.pinpoint.profiler.context.id.TransactionIdEncoder;
import com.navercorp.pinpoint.profiler.context.module.AgentId;
import com.navercorp.pinpoint.profiler.context.module.AgentStartTime;
import com.navercorp.pinpoint.profiler.context.module.ApplicationName;
import com.navercorp.pinpoint.profiler.context.module.ApplicationServerType;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.profiler.context.thrift.SpanThriftMessageConverter;
import com.navercorp.pinpoint.thrift.dto.TSpan;
import com.navercorp.pinpoint.thrift.dto.TSpanChunk;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.thrift.TBase;

public class SpanThriftMessageConverterProvider
implements Provider<MessageConverter<SpanType, TBase<?, ?>>> {
    private final String applicationName;
    private final String agentId;
    private final long agentStartTime;
    private final ServiceType applicationServiceType;
    private final TransactionIdEncoder transactionIdEncoder;
    private final SpanProcessor<TSpan, TSpanChunk> spanPostProcessor;

    @Inject
    public SpanThriftMessageConverterProvider(@ApplicationName String applicationName, @AgentId String agentId, @AgentStartTime long agentStartTime, @ApplicationServerType ServiceType applicationServiceType, TransactionIdEncoder transactionIdEncoder, SpanProcessor<TSpan, TSpanChunk> spanPostProcessor) {
        this.applicationName = Objects.requireNonNull(applicationName, "applicationName");
        this.agentId = Objects.requireNonNull(agentId, "agentId");
        this.agentStartTime = agentStartTime;
        this.applicationServiceType = Objects.requireNonNull(applicationServiceType, "applicationServiceType");
        this.transactionIdEncoder = Objects.requireNonNull(transactionIdEncoder, "transactionIdEncoder");
        this.spanPostProcessor = Objects.requireNonNull(spanPostProcessor, "spanPostProcessor");
    }

    public MessageConverter<SpanType, TBase<?, ?>> get() {
        return new SpanThriftMessageConverter(this.applicationName, this.agentId, this.agentStartTime, this.applicationServiceType.getCode(), this.transactionIdEncoder, this.spanPostProcessor);
    }
}

