/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.transformer;

import com.navercorp.pinpoint.bootstrap.instrument.matcher.BasedMatcher;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.Matcher;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.MatcherType;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operand.ClassInternalNameMatcherOperand;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operand.MatcherOperand;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operand.PackageInternalNameMatcherOperand;
import com.navercorp.pinpoint.profiler.instrument.classreading.InternalClassMetadata;
import com.navercorp.pinpoint.profiler.instrument.classreading.InternalClassMetadataReader;
import com.navercorp.pinpoint.profiler.instrument.config.InstrumentMatcherCacheConfig;
import com.navercorp.pinpoint.profiler.instrument.transformer.DefaultTransformerMatcher;
import com.navercorp.pinpoint.profiler.instrument.transformer.DefaultTransformerRegistry;
import com.navercorp.pinpoint.profiler.instrument.transformer.TransformerMatcher;
import com.navercorp.pinpoint.profiler.instrument.transformer.TransformerMatcherExecutionPlanner;
import com.navercorp.pinpoint.profiler.instrument.transformer.TransformerRegistry;
import com.navercorp.pinpoint.profiler.plugin.MatchableClassFileTransformer;
import java.lang.instrument.ClassFileTransformer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MatchableTransformerRegistry
implements TransformerRegistry {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final DefaultTransformerRegistry defaultTransformerRegistry;
    private final Map<String, IndexValue> classNameBasedIndex = new HashMap<String, IndexValue>(64);
    private final Map<String, Set<IndexValue>> packageNameBasedIndex;
    private final TransformerMatcherExecutionPlanner executionPlanner = new TransformerMatcherExecutionPlanner();
    private final TransformerMatcher transformerMatcher;

    public MatchableTransformerRegistry(InstrumentMatcherCacheConfig instrumentMatcherCacheConfig, List<MatchableClassFileTransformer> matchableClassFileTransformerList) {
        Objects.requireNonNull(instrumentMatcherCacheConfig, "instrumentMatcherCacheConfig");
        Objects.requireNonNull(matchableClassFileTransformerList, "matchableClassFileTransformerList");
        List<MatchableClassFileTransformer> defaultTransfomerList = this.filterDefaultMatcher(matchableClassFileTransformerList);
        this.defaultTransformerRegistry = new DefaultTransformerRegistry(defaultTransfomerList);
        this.packageNameBasedIndex = new TreeMap<String, Set<IndexValue>>(new Comparator<String>(){

            @Override
            public int compare(String key1, String key2) {
                return key1.compareTo(key2);
            }
        });
        List<MatchableClassFileTransformer> baseTransformer = this.filterBaseMatcher(matchableClassFileTransformerList);
        for (MatchableClassFileTransformer transformer : baseTransformer) {
            try {
                this.addTransformer(transformer.getMatcher(), transformer);
            }
            catch (Exception ex) {
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn("Failed to add transformer {}", (Object)transformer, (Object)ex);
            }
        }
        this.transformerMatcher = new DefaultTransformerMatcher(instrumentMatcherCacheConfig);
    }

    @Override
    public ClassFileTransformer findTransformer(ClassLoader classLoader, String classInternalName, byte[] classFileBuffer) {
        return this.findTransformer(classLoader, classInternalName, classFileBuffer, null);
    }

    @Override
    public ClassFileTransformer findTransformer(ClassLoader classLoader, String classInternalName, byte[] classFileBuffer, InternalClassMetadata classMetadata) {
        ClassFileTransformer packagedBasedTransformer;
        ClassFileTransformer classBaseTransformer;
        ClassFileTransformer transformer = this.defaultTransformerRegistry.findTransformer(classLoader, classInternalName, classFileBuffer);
        if (transformer != null) {
            return transformer;
        }
        ClassMetadataWrapper classMetadataWrapper = new ClassMetadataWrapper(classFileBuffer, classMetadata);
        if (!this.classNameBasedIndex.isEmpty() && (classBaseTransformer = this.findClassBasedTransformer(classLoader, classInternalName, classMetadataWrapper)) != null) {
            return classBaseTransformer;
        }
        if (!this.packageNameBasedIndex.isEmpty() && (packagedBasedTransformer = this.findPackageBasedTransformer(classLoader, classInternalName, classMetadataWrapper)) != null) {
            return packagedBasedTransformer;
        }
        return null;
    }

    private ClassFileTransformer findClassBasedTransformer(ClassLoader classLoader, String classInternalName, ClassMetadataWrapper classMetadataWrapper) {
        IndexValue indexValue = this.classNameBasedIndex.get(classInternalName);
        if (indexValue != null) {
            if (indexValue.operand instanceof ClassInternalNameMatcherOperand) {
                return indexValue.transformer;
            }
            ClassFileTransformer transformer = this.match(classLoader, indexValue, classMetadataWrapper);
            if (transformer != null) {
                return transformer;
            }
        }
        return null;
    }

    private ClassFileTransformer findPackageBasedTransformer(ClassLoader classLoader, String classInternalName, ClassMetadataWrapper classMetadataWrapper) {
        for (Map.Entry<String, Set<IndexValue>> entry : this.packageNameBasedIndex.entrySet()) {
            String packageInternalName = entry.getKey();
            if (!classInternalName.startsWith(packageInternalName)) continue;
            for (IndexValue value : entry.getValue()) {
                ClassFileTransformer transformer = this.match(classLoader, value, classMetadataWrapper);
                if (transformer == null) continue;
                return transformer;
            }
        }
        return null;
    }

    private ClassFileTransformer match(ClassLoader classLoader, IndexValue indexValue, ClassMetadataWrapper classMetadataWrapper) {
        long startTime = System.currentTimeMillis();
        if (this.transformerMatcher.match(classLoader, indexValue.operand, classMetadataWrapper.get())) {
            long elapsedTime = indexValue.accumulatorTime(startTime);
            if (this.isDebug) {
                this.logger.debug("Matching time elapsed={}ms, accumulator={}ms, operand={}", (Object)elapsedTime, (Object)indexValue.accumulatorTimeMillis, (Object)indexValue.operand);
            }
            return indexValue.transformer;
        }
        indexValue.accumulatorTime(startTime);
        return null;
    }

    private void addTransformer(Matcher matcher, ClassFileTransformer transformer) {
        if (!MatcherType.isBasedMatcher((Matcher)matcher)) {
            throw new IllegalArgumentException("unsupported baseMatcher");
        }
        MatcherOperand matcherOperand = ((BasedMatcher)matcher).getMatcherOperand();
        this.addIndex(matcherOperand, transformer);
    }

    private List<MatchableClassFileTransformer> filterBaseMatcher(List<MatchableClassFileTransformer> matchableClassFileTransformerList) {
        ArrayList<MatchableClassFileTransformer> filter = new ArrayList<MatchableClassFileTransformer>();
        for (MatchableClassFileTransformer transformer : matchableClassFileTransformerList) {
            if (!MatcherType.isBasedMatcher((Matcher)transformer.getMatcher())) continue;
            filter.add(transformer);
        }
        return filter;
    }

    private List<MatchableClassFileTransformer> filterDefaultMatcher(List<MatchableClassFileTransformer> matchableClassFileTransformerList) {
        ArrayList<MatchableClassFileTransformer> filter = new ArrayList<MatchableClassFileTransformer>();
        for (MatchableClassFileTransformer transformer : matchableClassFileTransformerList) {
            if (MatcherType.isBasedMatcher((Matcher)transformer.getMatcher())) continue;
            filter.add(transformer);
        }
        return filter;
    }

    private void addIndex(MatcherOperand condition, ClassFileTransformer transformer) {
        List<MatcherOperand> indexedMatcherOperands = this.executionPlanner.findIndex(condition);
        if (indexedMatcherOperands.isEmpty()) {
            throw new IllegalArgumentException("invalid matcher - not found index operand. condition=" + condition);
        }
        IndexValue indexValue = new IndexValue(condition, transformer);
        for (MatcherOperand operand : indexedMatcherOperands) {
            boolean indexed;
            if (operand instanceof ClassInternalNameMatcherOperand) {
                ClassInternalNameMatcherOperand classInternalNameMatcherOperand = (ClassInternalNameMatcherOperand)operand;
                IndexValue prev = this.classNameBasedIndex.put(classInternalNameMatcherOperand.getClassInternalName(), indexValue);
                if (prev != null) {
                    throw new IllegalStateException("Transformer already exist. class=" + classInternalNameMatcherOperand.getClassInternalName() + ", new=" + indexValue + ", prev=" + prev);
                }
                indexed = true;
            } else if (operand instanceof PackageInternalNameMatcherOperand) {
                PackageInternalNameMatcherOperand packageInternalNameMatcherOperand = (PackageInternalNameMatcherOperand)operand;
                this.addIndexData(packageInternalNameMatcherOperand.getPackageInternalName(), indexValue, this.packageNameBasedIndex);
                indexed = true;
            } else {
                throw new IllegalArgumentException("invalid matcher or execution planner - unknown operand. condition=" + condition + ", unknown operand=" + operand);
            }
            if (indexed) continue;
            throw new IllegalArgumentException("invalid matcher or execution planner - no such indexed operand. operand=" + condition);
        }
    }

    private void addIndexData(String key, IndexValue indexValue, Map<String, Set<IndexValue>> index) {
        Set<IndexValue> indexValueSet = index.get(key);
        if (indexValueSet == null) {
            indexValueSet = new HashSet<IndexValue>();
            index.put(key, indexValueSet);
        }
        indexValueSet.add(indexValue);
    }

    class ClassMetadataWrapper {
        private final byte[] classFileBuffer;
        private InternalClassMetadata classMetadata;

        ClassMetadataWrapper(byte[] classFileBuffer, InternalClassMetadata classMetadata) {
            this.classFileBuffer = classFileBuffer;
            this.classMetadata = classMetadata;
        }

        public InternalClassMetadata get() {
            if (this.classMetadata == null) {
                try {
                    this.classMetadata = InternalClassMetadataReader.readInternalClassMetadata(this.classFileBuffer);
                }
                catch (Exception e) {
                    if (MatchableTransformerRegistry.this.logger.isInfoEnabled()) {
                        MatchableTransformerRegistry.this.logger.info("Failed to read metadata of class bytes.", (Throwable)e);
                    }
                    return null;
                }
            }
            return this.classMetadata;
        }
    }

    static class IndexValue {
        private final MatcherOperand operand;
        private final ClassFileTransformer transformer;
        private final AtomicLong accumulatorTimeMillis = new AtomicLong(0L);

        public IndexValue(MatcherOperand operand, ClassFileTransformer transformer) {
            this.operand = operand;
            this.transformer = transformer;
        }

        public long accumulatorTime(long startTimeMillis) {
            long elapsedTimeMillis = System.currentTimeMillis() - startTimeMillis;
            this.accumulatorTimeMillis.addAndGet(elapsedTimeMillis);
            return elapsedTimeMillis;
        }
    }
}

