/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor.metric.transaction;

import com.navercorp.pinpoint.profiler.context.id.TransactionCounter;
import com.navercorp.pinpoint.profiler.monitor.metric.transaction.TransactionMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.transaction.TransactionMetricSnapshot;
import java.util.Objects;

public class DefaultTransactionMetric
implements TransactionMetric {
    private final TransactionGauge sampledNewGauge;
    private final TransactionGauge sampledContinuationGauge;
    private final TransactionGauge unsampledNewGauge;
    private final TransactionGauge unsampledContinuationGauge;
    private final TransactionGauge skippedNewGauge;
    private final TransactionGauge skippedContinuationGauge;

    public DefaultTransactionMetric(final TransactionCounter transactionCounter) {
        Objects.requireNonNull(transactionCounter, "transactionCounter");
        this.sampledNewGauge = TransactionGauge.from(new LongCounter(){

            @Override
            public long getCount() {
                return transactionCounter.getSampledNewCount();
            }
        });
        this.sampledContinuationGauge = TransactionGauge.from(new LongCounter(){

            @Override
            public long getCount() {
                return transactionCounter.getSampledContinuationCount();
            }
        });
        this.unsampledNewGauge = TransactionGauge.from(new LongCounter(){

            @Override
            public long getCount() {
                return transactionCounter.getUnSampledNewCount();
            }
        });
        this.unsampledContinuationGauge = TransactionGauge.from(new LongCounter(){

            @Override
            public long getCount() {
                return transactionCounter.getUnSampledContinuationCount();
            }
        });
        this.skippedNewGauge = TransactionGauge.from(new LongCounter(){

            @Override
            public long getCount() {
                return transactionCounter.getSkippedNewCount();
            }
        });
        this.skippedContinuationGauge = TransactionGauge.from(new LongCounter(){

            @Override
            public long getCount() {
                return transactionCounter.getSkippedContinuationCount();
            }
        });
    }

    @Override
    public TransactionMetricSnapshot getSnapshot() {
        long sampledNewCount = this.sampledNewGauge.getTransactionCount();
        long sampledContinuationCount = this.sampledContinuationGauge.getTransactionCount();
        long unsampledNewCount = this.unsampledNewGauge.getTransactionCount();
        long unsampledContinuationCount = this.unsampledContinuationGauge.getTransactionCount();
        long skippedNewCount = this.skippedNewGauge.getTransactionCount();
        long skippedContinuationCount = this.skippedContinuationGauge.getTransactionCount();
        return new TransactionMetricSnapshot(sampledNewCount, sampledContinuationCount, unsampledNewCount, unsampledContinuationCount, skippedNewCount, skippedContinuationCount);
    }

    public String toString() {
        return "Default TransactionMetric";
    }

    private static class TransactionGauge {
        private static final long UNINITIALIZED = -1L;
        private long prevTransactionCount = -1L;
        private final LongCounter longCounter;

        static TransactionGauge from(LongCounter longCounter) {
            return new TransactionGauge(longCounter);
        }

        private TransactionGauge(LongCounter longCounter) {
            this.longCounter = Objects.requireNonNull(longCounter, "longCounter");
        }

        private long getTransactionCount() {
            long transactionCount = this.longCounter.getCount();
            if (transactionCount < 0L) {
                return -1L;
            }
            if (this.prevTransactionCount == -1L) {
                this.prevTransactionCount = transactionCount;
                return 0L;
            }
            long transactionCountDelta = transactionCount - this.prevTransactionCount;
            this.prevTransactionCount = transactionCount;
            return transactionCountDelta;
        }
    }

    private static interface LongCounter {
        public long getCount();
    }
}

