/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor.metric.uri;

import com.navercorp.pinpoint.common.trace.UriStatHistogramBucket;
import java.util.Arrays;

public class UriStatHistogram {
    private static final byte BUCKET_VERSION = UriStatHistogramBucket.getBucketVersion();
    private int count;
    private long total;
    private long max = 0L;
    private final int[] timestampHistogram = new int[UriStatHistogramBucket.getBucketSize()];

    public void add(long elapsed) {
        ++this.count;
        this.total += elapsed;
        this.max = Math.max(this.max, elapsed);
        UriStatHistogramBucket uriStatHistogramBucket = UriStatHistogramBucket.getValue((long)elapsed);
        int n = uriStatHistogramBucket.getIndex();
        int n2 = this.timestampHistogram[n] + 1;
        this.timestampHistogram[n] = n2;
        this.timestampHistogram[uriStatHistogramBucket.getIndex()] = n2;
    }

    private boolean isEmpty() {
        return this.count == 0;
    }

    public int getCount() {
        return this.count;
    }

    public long getTotal() {
        return this.total;
    }

    public long getMax() {
        return this.max;
    }

    public int[] getTimestampHistogram() {
        return this.timestampHistogram;
    }

    public byte getBucketVersion() {
        return BUCKET_VERSION;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("UriStatHistogram{");
        sb.append("count=").append(this.count);
        sb.append(", total=").append(this.total);
        sb.append(", max=").append(this.max);
        sb.append(", timestampHistogram=").append(Arrays.toString(this.timestampHistogram));
        sb.append('}');
        return sb.toString();
    }
}

