/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.mongodb.utils;

import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import org.apache.eventmesh.storage.mongodb.client.MongodbClientManager;
import org.apache.eventmesh.storage.mongodb.config.ConfigurationHolder;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongodbSequenceUtil {
    private final MongoClient mongoClient;
    private final MongoDatabase db;
    private final MongoCollection<Document> seqCol;

    public MongodbSequenceUtil(ConfigurationHolder configurationHolder) {
        this.mongoClient = MongodbClientManager.createMongodbClient(configurationHolder.getUrl());
        this.db = this.mongoClient.getDatabase(configurationHolder.getDatabase());
        this.seqCol = this.db.getCollection("pub_sub_seq");
    }

    public int getNextSeq(String topic) {
        Document query = new Document("topic", (Object)topic);
        Document update = new Document("$inc", (Object)new BasicDBObject("value", (Object)1));
        FindOneAndUpdateOptions options = new FindOneAndUpdateOptions();
        options.upsert(true);
        options.returnDocument(ReturnDocument.AFTER);
        Document result = (Document)this.seqCol.findOneAndUpdate((Bson)query, (Bson)update, options);
        return (Integer)result.get((Object)"value");
    }
}

