/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.cluster;

import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.rpc.cluster.Role;
import com.navercorp.pinpoint.rpc.util.MapUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClusterOption {
    public static final ClusterOption DISABLE_CLUSTER_OPTION = new ClusterOption(false, "", Collections.emptyList());
    private final boolean enable;
    private final String id;
    private final List<Role> roles;

    public ClusterOption(boolean enable, String id, String role) {
        this(enable, id, Role.getValue(role));
    }

    public ClusterOption(boolean enable, String id, Role role) {
        this(enable, id, Arrays.asList(role));
    }

    public ClusterOption(ClusterOption clusterOption) {
        this(clusterOption.enable, clusterOption.id, new ArrayList<Role>(clusterOption.roles));
    }

    public ClusterOption(boolean enable, String id, List<Role> roles) {
        this.enable = enable;
        this.id = id;
        this.roles = roles;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public String getId() {
        return this.id;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public Map<String, Object> toMap() {
        if (!this.enable) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> clusterProperties = new HashMap<String, Object>(2);
        clusterProperties.put("id", this.id);
        ArrayList<String> roleList = new ArrayList<String>(this.roles.size());
        for (Role role : this.roles) {
            roleList.add(role.name());
        }
        clusterProperties.put("roles", roleList);
        return clusterProperties;
    }

    public static ClusterOption getClusterOption(Map<?, ?> handshakeResponse) {
        if (MapUtils.isEmpty(handshakeResponse)) {
            return DISABLE_CLUSTER_OPTION;
        }
        Map cluster = (Map)handshakeResponse.get("cluster");
        if (cluster == null) {
            return DISABLE_CLUSTER_OPTION;
        }
        String id = MapUtils.getString(cluster, "id", "");
        List<Role> roles = ClusterOption.getRoles(cluster.get("roles"));
        if (StringUtils.isEmpty((String)id)) {
            return DISABLE_CLUSTER_OPTION;
        }
        return new ClusterOption(true, id, roles);
    }

    private static List<Role> getRoles(Object roleNames) {
        if (!(roleNames instanceof List)) {
            return new ArrayList<Role>();
        }
        ArrayList<Role> roles = new ArrayList<Role>();
        List list = (List)roleNames;
        for (Object roleName : list) {
            if (!(roleName instanceof String) || !StringUtils.hasLength((String)((String)roleName))) continue;
            roles.add(Role.getValue((String)roleName));
        }
        return roles;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ClusterOption{");
        sb.append("enable=").append(this.enable);
        sb.append(", id='").append(this.id).append('\'');
        sb.append(", roles=").append(this.roles);
        sb.append('}');
        return sb.toString();
    }

    public static ClusterOption copy(ClusterOption clusterOption) {
        return new ClusterOption(clusterOption.enable, clusterOption.id, clusterOption.roles);
    }
}

