/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.http.HttpCommand;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.body.message.ReplyMessageResponseBody;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.protocol.http.header.Header;
import org.apache.eventmesh.common.protocol.http.header.message.ReplyMessageRequestHeader;
import org.apache.eventmesh.common.protocol.http.header.message.ReplyMessageResponseHeader;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.metrics.api.model.HttpSummaryMetrics;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.ProtocolPluginFactory;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.configuration.EventMeshHTTPConfiguration;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.async.CompleteHandler;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.HttpRequestProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.http.producer.SendMessageContext;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplyMessageProcessor
implements HttpRequestProcessor {
    public final Logger messageLogger = LoggerFactory.getLogger((String)"message");
    public final Logger cmdLogger = LoggerFactory.getLogger((String)"cmd");
    public final Logger httpLogger = LoggerFactory.getLogger((String)"http");
    private final EventMeshHTTPServer eventMeshHTTPServer;

    public ReplyMessageProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    @Override
    public void processRequest(ChannelHandlerContext ctx, final AsyncContext<HttpCommand> asyncContext) throws Exception {
        String content;
        String producerGroup;
        String uniqueId;
        String sys;
        String pid;
        String localAddress = IPUtils.getLocalAddress();
        final HttpCommand request = asyncContext.getRequest();
        this.cmdLogger.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{RequestCode.get((Integer)Integer.valueOf(request.getRequestCode())), "http", RemotingHelper.parseChannelRemoteAddr(ctx.channel()), localAddress});
        ReplyMessageRequestHeader replyMessageRequestHeader = (ReplyMessageRequestHeader)request.getHeader();
        String protocolType = replyMessageRequestHeader.getProtocolType();
        ProtocolAdaptor httpCommandProtocolAdaptor = ProtocolPluginFactory.getProtocolAdaptor((String)protocolType);
        CloudEvent event = httpCommandProtocolAdaptor.toCloudEvent((ProtocolTransportObject)request);
        EventMeshHTTPConfiguration httpConfiguration = this.eventMeshHTTPServer.getEventMeshHttpConfiguration();
        final ReplyMessageResponseHeader replyMessageResponseHeader = ReplyMessageResponseHeader.buildHeader((Integer)Integer.valueOf(request.getRequestCode()), (String)httpConfiguration.getEventMeshCluster(), (String)localAddress, (String)httpConfiguration.getEventMeshEnv(), (String)httpConfiguration.getEventMeshIDC());
        if (!ObjectUtils.allNotNull((Object[])new Object[]{event, event.getSource(), event.getSpecVersion()}) || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{event.getId(), event.getType(), event.getSubject()})) {
            this.completeResponse(request, asyncContext, replyMessageResponseHeader, EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR, null, ReplyMessageResponseBody.class);
            return;
        }
        String idc = this.getExtension(event, "idc");
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{idc, pid = this.getExtension(event, "pid"), sys = this.getExtension(event, "sys")}) || !StringUtils.isNumeric((CharSequence)pid)) {
            this.completeResponse(request, asyncContext, replyMessageResponseHeader, EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR, null, ReplyMessageResponseBody.class);
            return;
        }
        final String bizNo = this.getExtension(event, "bizseqno");
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{bizNo, uniqueId = this.getExtension(event, "uniqueid"), producerGroup = this.getExtension(event, "producergroup")}) || event.getData() == null) {
            this.completeResponse(request, asyncContext, replyMessageResponseHeader, EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR, null, ReplyMessageResponseBody.class);
            return;
        }
        final HttpSummaryMetrics summaryMetrics = this.eventMeshHTTPServer.getMetrics().getSummaryMetrics();
        if (!this.eventMeshHTTPServer.getMsgRateLimiter().tryAcquire(100L, TimeUnit.MILLISECONDS)) {
            summaryMetrics.recordHTTPDiscard();
            this.completeResponse(request, asyncContext, replyMessageResponseHeader, EventMeshRetCode.EVENTMESH_HTTP_MES_SEND_OVER_LIMIT_ERR, null, ReplyMessageResponseBody.class);
            return;
        }
        String string = content = event.getData() == null ? "" : new String(event.getData().toBytes(), Constants.DEFAULT_CHARSET);
        if (content.length() > httpConfiguration.getEventMeshEventSize()) {
            this.httpLogger.error("Event size exceeds the limit: {}", (Object)httpConfiguration.getEventMeshEventSize());
            this.completeResponse(request, asyncContext, replyMessageResponseHeader, EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR, "Event size exceeds the limit: " + httpConfiguration.getEventMeshEventSize(), ReplyMessageResponseBody.class);
            return;
        }
        EventMeshProducer eventMeshProducer = this.eventMeshHTTPServer.getProducerManager().getEventMeshProducer(producerGroup);
        if (!eventMeshProducer.isStarted()) {
            this.completeResponse(request, asyncContext, replyMessageResponseHeader, EventMeshRetCode.EVENTMESH_GROUP_PRODUCER_STOPED_ERR, null, ReplyMessageResponseBody.class);
            return;
        }
        final long startTime = System.currentTimeMillis();
        String replyTopic = "rr-reply-topic";
        final String origTopic = event.getSubject();
        final String replyMQCluster = this.getExtension(event, "cluster");
        if (StringUtils.isEmpty((CharSequence)replyMQCluster)) {
            this.completeResponse(request, asyncContext, replyMessageResponseHeader, EventMeshRetCode.EVENTMESH_REPLY_MSG_ERR, null, ReplyMessageResponseBody.class);
            return;
        }
        replyTopic = replyMQCluster + "-" + replyTopic;
        try {
            event = CloudEventBuilder.from((CloudEvent)event).withSubject(replyTopic).withExtension("msgtype", "persistent").withExtension("timeout", String.valueOf(3000)).withExtension("reqc2eventmeshtimestamp", String.valueOf(System.currentTimeMillis())).build();
            if (this.messageLogger.isDebugEnabled()) {
                this.messageLogger.debug("msg2MQMsg suc, bizSeqNo={}, topic={}", (Object)bizNo, (Object)replyTopic);
            }
        }
        catch (Exception e) {
            this.messageLogger.error("msg2MQMsg err, bizSeqNo={}, topic={}", new Object[]{bizNo, replyTopic, e});
            this.completeResponse(request, asyncContext, replyMessageResponseHeader, EventMeshRetCode.EVENTMESH_PACKAGE_MSG_ERR, EventMeshRetCode.EVENTMESH_PACKAGE_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2), ReplyMessageResponseBody.class);
            return;
        }
        SendMessageContext sendMessageContext = new SendMessageContext(bizNo, event, eventMeshProducer, this.eventMeshHTTPServer);
        summaryMetrics.recordReplyMsg();
        final CompleteHandler<HttpCommand> handler = httpCommand -> {
            try {
                if (this.httpLogger.isDebugEnabled()) {
                    this.httpLogger.debug("{}", httpCommand);
                }
                this.eventMeshHTTPServer.sendResponse(ctx, httpCommand.httpResponse());
                summaryMetrics.recordHTTPReqResTimeCost(System.currentTimeMillis() - request.getReqTime());
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
        try {
            CloudEvent clone = CloudEventBuilder.from((CloudEvent)sendMessageContext.getEvent()).withExtension("reqeventmesh2mqtimestamp", String.valueOf(System.currentTimeMillis())).build();
            sendMessageContext.setEvent(clone);
            eventMeshProducer.reply(sendMessageContext, new SendCallback(){

                public void onSuccess(SendResult sendResult) {
                    HttpCommand succ = request.createHttpCommandResponse((Header)replyMessageResponseHeader, (Body)ReplyMessageResponseBody.buildBody((Integer)EventMeshRetCode.SUCCESS.getRetCode(), (String)EventMeshRetCode.SUCCESS.getErrMsg()));
                    asyncContext.onComplete(succ, handler);
                    long endTime = System.currentTimeMillis();
                    summaryMetrics.recordReplyMsgCost(endTime - startTime);
                    ReplyMessageProcessor.this.messageLogger.info("message|eventMesh2mq|RSP|SYNC|reply2MQCost={}|topic={}|origTopic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, replyMQCluster + "-" + "rr-reply-topic", origTopic, bizNo, uniqueId});
                }

                public void onException(OnExceptionContext context) {
                    HttpCommand err = request.createHttpCommandResponse((Header)replyMessageResponseHeader, (Body)ReplyMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_REPLY_MSG_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_REPLY_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace((Throwable)context.getException(), 2))));
                    asyncContext.onComplete(err, handler);
                    long endTime = System.currentTimeMillis();
                    summaryMetrics.recordReplyMsgFailed();
                    summaryMetrics.recordReplyMsgCost(endTime - startTime);
                    ReplyMessageProcessor.this.messageLogger.error("message|eventMesh2mq|RSP|SYNC|reply2MQCost={}|topic={}|origTopic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, replyMQCluster + "-" + "rr-reply-topic", origTopic, bizNo, uniqueId, context.getException()});
                }
            });
        }
        catch (Exception ex) {
            this.completeResponse(request, asyncContext, replyMessageResponseHeader, EventMeshRetCode.EVENTMESH_REPLY_MSG_ERR, EventMeshRetCode.EVENTMESH_REPLY_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace(ex, 2), ReplyMessageResponseBody.class);
            long endTime = System.currentTimeMillis();
            this.messageLogger.error("message|eventMesh2mq|RSP|SYNC|reply2MQCost={}|topic={}|origTopic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, replyTopic, origTopic, bizNo, uniqueId, ex});
            summaryMetrics.recordReplyMsgFailed();
            summaryMetrics.recordReplyMsgCost(endTime - startTime);
        }
    }
}

