/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.retry;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.common.EventMeshThreadFactory;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.core.protocol.DelayRetryable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRetryer {
    private static final Logger log = LoggerFactory.getLogger(HttpRetryer.class);
    private final Logger retryLogger = LoggerFactory.getLogger((String)"retry");
    private final EventMeshHTTPServer eventMeshHTTPServer;
    private final DelayQueue<DelayRetryable> failed = new DelayQueue();
    private ThreadPoolExecutor pool;
    private Thread dispatcher;

    public HttpRetryer(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    public void pushRetry(DelayRetryable delayRetryable) {
        if (this.failed.size() >= this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshServerRetryBlockQSize()) {
            this.retryLogger.error("[RETRY-QUEUE] is full!");
            return;
        }
        this.failed.offer(delayRetryable);
    }

    public void init() {
        this.pool = new ThreadPoolExecutor(this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshServerRetryThreadNum(), this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshServerRetryThreadNum(), 60000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshServerRetryBlockQSize()), (ThreadFactory)new EventMeshThreadFactory("http-retry", true, Integer.valueOf(5)), new ThreadPoolExecutor.AbortPolicy());
        this.dispatcher = new Thread(() -> {
            try {
                DelayRetryable retryObj;
                while (!Thread.currentThread().isInterrupted() && (retryObj = (DelayRetryable)this.failed.take()) != null) {
                    DelayRetryable delayRetryable = retryObj;
                    this.pool.execute(() -> {
                        try {
                            delayRetryable.retry();
                            if (this.retryLogger.isDebugEnabled()) {
                                this.retryLogger.debug("retryObj : {}", (Object)delayRetryable);
                            }
                        }
                        catch (Exception e) {
                            this.retryLogger.error("http-retry-dispatcher error!", (Throwable)e);
                        }
                    });
                }
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                this.retryLogger.error("http-retry-dispatcher error!", (Throwable)e);
            }
        }, "http-retry-dispatcher");
        this.dispatcher.setDaemon(true);
        log.info("HttpRetryer inited......");
    }

    public int size() {
        return this.failed.size();
    }

    public DelayQueue<DelayRetryable> getFailedQueue() {
        return this.failed;
    }

    public void shutdown() {
        this.dispatcher.interrupt();
        this.pool.shutdown();
        log.info("HttpRetryer shutdown......");
    }

    public void start() throws Exception {
        this.dispatcher.start();
        log.info("HttpRetryer started......");
    }
}

