/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc;

import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.grpc.Header;
import com.navercorp.pinpoint.grpc.client.HeaderFactory;
import io.grpc.Metadata;
import java.util.Objects;

public class AgentHeaderFactory
implements HeaderFactory {
    private final String agentId;
    private final String agentName;
    private final String applicationName;
    private final long agentStartTime;
    private final int serviceType;

    public AgentHeaderFactory(String agentId, String agentName, String applicationName, int serviceType, long agentStartTime) {
        this.agentId = Objects.requireNonNull(agentId, "agentId");
        this.agentName = agentName;
        this.applicationName = Objects.requireNonNull(applicationName, "applicationName");
        this.serviceType = serviceType;
        this.agentStartTime = agentStartTime;
    }

    @Override
    public Metadata newHeader() {
        Metadata headers = new Metadata();
        headers.put(Header.AGENT_ID_KEY, (Object)this.agentId);
        headers.put(Header.APPLICATION_NAME_KEY, (Object)this.applicationName);
        headers.put(Header.SERVICE_TYPE_KEY, (Object)Integer.toString(this.serviceType));
        headers.put(Header.AGENT_START_TIME_KEY, (Object)Long.toString(this.agentStartTime));
        if (!StringUtils.isEmpty((String)this.agentName)) {
            headers.put(Header.AGENT_NAME_KEY, (Object)this.agentName);
        }
        return headers;
    }
}

