/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.client.config;

import com.navercorp.pinpoint.bootstrap.config.Value;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.grpc.util.FileSystemResource;
import com.navercorp.pinpoint.grpc.util.Resource;
import java.util.Objects;

public class SslOption {
    public static final boolean DISABLE = Boolean.FALSE;
    public static final String DEFAULT_PROVIDER_TYPE = "jdk";
    public static final Resource DEFAULT_TRUST_CERT_RESOURCE = null;
    private final boolean enable;
    private final String providerType;
    private final Resource trustCertResource;

    private SslOption(boolean enable, String providerType, Resource trustCertResource) {
        this.enable = enable;
        this.providerType = providerType;
        this.trustCertResource = trustCertResource;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public String getProviderType() {
        return this.providerType;
    }

    public Resource getTrustCertResource() {
        return this.trustCertResource;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SslOption{");
        sb.append("enable=").append(this.enable);
        sb.append(", providerType='").append(this.providerType).append('\'');
        sb.append(", trustCertResource=").append(this.trustCertResource);
        sb.append('}');
        return sb.toString();
    }

    public static class Builder {
        private final String basePath;
        @Value(value="${enable}")
        private boolean enable;
        @Value(value="${provider.type}")
        private String providerType;
        @Value(value="${trust.cert.file.path}")
        private String trustCertFilePath;
        private static final String CLASSPATH_URL_PREFIX = "classpath:";
        private static final String FILE_URL_PREFIX = "file:";

        public Builder(String basePath) {
            this.basePath = basePath;
        }

        public String getBasePath() {
            return this.basePath;
        }

        public boolean isEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public String getProviderType() {
            return this.providerType;
        }

        public void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        public String getTrustCertFilePath() {
            return this.trustCertFilePath;
        }

        public void setTrustCertFilePath(String trustCertFilePath) {
            this.trustCertFilePath = trustCertFilePath;
        }

        public SslOption build() {
            if (this.enable) {
                Objects.requireNonNull(this.providerType);
                Resource trustCertResource = this.toResource(this.trustCertFilePath);
                return new SslOption(true, this.providerType, trustCertResource);
            }
            return new SslOption(this.enable, SslOption.DEFAULT_PROVIDER_TYPE, DEFAULT_TRUST_CERT_RESOURCE);
        }

        private Resource toResource(String filePath) {
            if (!StringUtils.hasText((String)filePath)) {
                return null;
            }
            Resource resource = null;
            if (filePath.startsWith(CLASSPATH_URL_PREFIX)) {
                String path = filePath.substring(CLASSPATH_URL_PREFIX.length());
                resource = FileSystemResource.createResource(this.basePath, path);
            } else if (filePath.startsWith(FILE_URL_PREFIX)) {
                String path = filePath.substring(FILE_URL_PREFIX.length());
                resource = FileSystemResource.createResource(path);
            }
            if (resource != null && resource.exists()) {
                return resource;
            }
            throw new IllegalArgumentException("Could not find file.(path:" + filePath + ")");
        }
    }
}

