/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.security;

import com.navercorp.pinpoint.grpc.util.Resource;
import java.util.Objects;

public final class SslServerConfig {
    private static final boolean DISABLED = false;
    private static final String EMPTY_STRING = "";
    public static final SslServerConfig DISABLED_CONFIG = new SslServerConfig(false, "", null, null);
    private final boolean enable;
    private final String sslProviderType;
    private final Resource keyResource;
    private final Resource keyCertChainResource;

    public SslServerConfig(boolean enable, String sslProviderType, Resource keyResource, Resource keyCertChainResource) {
        this.enable = enable;
        this.sslProviderType = Objects.requireNonNull(sslProviderType, "sslProviderType");
        this.keyResource = keyResource;
        this.keyCertChainResource = keyCertChainResource;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public String getSslProviderType() {
        return this.sslProviderType;
    }

    public Resource getKeyResource() {
        return this.keyResource;
    }

    public Resource getKeyCertChainResource() {
        return this.keyCertChainResource;
    }

    public String toString() {
        return "SslServerConfig{enable=" + this.enable + ", sslProviderType='" + this.sslProviderType + '\'' + ", keyFileUrl='" + this.keyResource + '\'' + ", keyCertChainFileUrl='" + this.keyCertChainResource + '\'' + '}';
    }
}

